/*
 * SessionException.java May 2007
 *
 * Copyright (C) 2007, Niall Gallagher <niallg@users.sf.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General 
 * Public License along with this library; if not, write to the 
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA  02111-1307  USA
 */

package org.simpleframework.http.session;

import org.simpleframework.util.lease.LeaseException;

/**
 * The <code>SessionException</code> is used to indicate that some
 * operation failed when trying to access a session or when trying
 * to perform some operation on an existing session. Typically this
 * is thrown when a session no longer exists.
 *
 * @author Niall Gallagher
 */
public class SessionException extends LeaseException {
   
   /**
    * This constructor is used if there is a description of the 
    * event that caused the exception required. This can be given
    * a message used to describe the situation for the exception.
    * 
    * @param template this is a description of the exception
    * @param list this is the list of arguments that can be used
    */
   public SessionException(String template, Object... list) {
      super(template, list);
   }

}
