/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.core;

import java.io.IOException;
import org.simpleframework.http.core.ArrayConsumer;
import org.simpleframework.util.buffer.Allocator;
import org.simpleframework.util.buffer.Buffer;

class BoundaryConsumer
extends ArrayConsumer {
    private static final byte[] LAST = new byte[]{45, 45, 13, 10};
    private static final byte[] LINE = new byte[]{13, 10};
    private static final byte[] TOKEN = new byte[]{45, 45};
    private Allocator allocator;
    private Buffer buffer;
    private byte[] boundary;
    private int start;
    private int last;
    private int line;
    private int seek;
    private int pos;

    public BoundaryConsumer(Allocator allocator, byte[] boundary) {
        this.allocator = allocator;
        this.boundary = boundary;
    }

    protected void process() throws IOException {
        int length = this.boundary.length + 6;
        if (this.buffer == null) {
            this.buffer = this.allocator.allocate(length);
        }
        this.buffer.append(TOKEN);
        this.buffer.append(this.boundary);
        if (this.last == 4) {
            this.buffer.append(TOKEN);
        }
        this.buffer.append(LINE);
    }

    protected int scan() throws IOException {
        if (this.start != 2) {
            this.start();
        }
        if (this.start == 2) {
            this.boundary();
        }
        if (this.pos == this.boundary.length) {
            return this.terminal();
        }
        return 0;
    }

    private void start() throws IOException {
        if (this.start < 2) {
            while (this.seek < this.count) {
                if (this.array[this.seek++] == 45) {
                    if (++this.start != 2) continue;
                    break;
                }
                throw new IOException("Invalid boundary start");
            }
        }
    }

    private void boundary() throws IOException {
        if (this.pos < this.boundary.length) {
            while (this.seek < this.count) {
                if (this.array[this.seek++] != this.boundary[this.pos++]) {
                    throw new IOException("Invalid boundary value");
                }
                if (this.pos != this.boundary.length) continue;
                break;
            }
        }
    }

    private int terminal() throws IOException {
        while (this.seek < this.count) {
            if (this.array[this.seek] == LAST[this.last]) {
                if (++this.last == 4) {
                    this.done = true;
                    return this.count - ++this.seek;
                }
            } else if (this.array[this.seek] == LINE[this.line]) {
                if (++this.line == 2) {
                    this.done = true;
                    return this.count - ++this.seek;
                }
            } else {
                throw new IOException("Invalid boundary ending");
            }
            ++this.seek;
        }
        return 0;
    }

    public boolean isEnd() {
        return this.last == 4;
    }

    public void clear() {
        this.done = false;
        this.seek = 0;
        this.count = 0;
        this.start = 0;
        this.last = 0;
        this.pos = 0;
        this.line = 0;
    }
}

