/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.core;

import java.io.IOException;
import java.io.InputStream;
import org.simpleframework.http.core.EmptyInputStream;
import org.simpleframework.http.core.LargeConsumer;
import org.simpleframework.util.buffer.Allocator;
import org.simpleframework.util.buffer.Buffer;

class FixedConsumer
extends LargeConsumer {
    private Allocator allocator;
    private Buffer buffer;
    private int limit;

    public FixedConsumer(Allocator allocator, int limit) {
        this.allocator = allocator;
        this.limit = limit;
    }

    public String getContent() throws IOException {
        if (this.buffer == null) {
            return new String();
        }
        return this.buffer.encode();
    }

    public String getContent(String charset) throws IOException {
        if (this.buffer == null) {
            return new String();
        }
        return this.buffer.encode(charset);
    }

    public InputStream getInputStream() throws IOException {
        if (this.buffer == null) {
            return new EmptyInputStream();
        }
        return this.buffer.getInputStream();
    }

    protected int process(byte[] array, int off, int count) throws IOException {
        int mark = this.limit;
        if (count >= this.limit) {
            this.append(array, off, mark);
            this.finished = true;
            this.limit = 0;
            return count - mark;
        }
        if (count > 0) {
            this.append(array, off, count);
            this.limit -= count;
        }
        return 0;
    }

    protected Buffer allocate() throws IOException {
        if (this.buffer == null) {
            this.buffer = this.allocator.allocate(this.limit);
        }
        return this.buffer;
    }
}

