/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport;

import java.io.IOException;
import org.simpleframework.transport.Negotiator;
import org.simpleframework.transport.OperationFactory;
import org.simpleframework.transport.Processor;
import org.simpleframework.transport.SecureNegotiator;
import org.simpleframework.transport.Server;
import org.simpleframework.transport.Socket;
import org.simpleframework.transport.reactor.Operation;

public class ProcessorServer
implements Server {
    private final OperationFactory factory;
    private final Processor processor;
    private final Negotiator negotiator;

    public ProcessorServer(Processor processor) throws IOException {
        this(processor, 8);
    }

    public ProcessorServer(Processor processor, int count) throws IOException {
        this(processor, count, 20480);
    }

    public ProcessorServer(Processor processor, int count, int limit) throws IOException {
        this.negotiator = new SecureNegotiator(processor, count);
        this.factory = new OperationFactory(this.negotiator, limit);
        this.processor = processor;
    }

    public void process(Socket socket) throws IOException {
        Operation task = this.factory.getInstance(socket);
        if (task != null) {
            this.negotiator.process(task);
        }
    }

    public void stop() throws IOException {
        this.processor.stop();
        this.negotiator.stop();
    }
}

