/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport;

import java.io.IOException;
import java.nio.channels.SocketChannel;
import org.simpleframework.transport.Packet;
import org.simpleframework.transport.Segment;
import org.simpleframework.transport.SegmentBuilder;
import org.simpleframework.transport.Socket;
import org.simpleframework.transport.TransportException;
import org.simpleframework.transport.Writer;

class SocketWriter
implements Writer {
    private SegmentBuilder builder;
    private SocketChannel channel;
    private boolean closed;

    public SocketWriter(Socket socket) {
        this(socket, 20480);
    }

    public SocketWriter(Socket socket, int limit) {
        this.builder = new SegmentBuilder(limit);
        this.channel = socket.getChannel();
    }

    public synchronized SocketChannel getChannel() {
        return this.channel;
    }

    public synchronized boolean isBlocking() throws IOException {
        return this.builder.isReference();
    }

    public synchronized boolean write(Packet packet) throws IOException {
        Segment segment = this.builder.build(packet);
        if (segment == null) {
            return true;
        }
        return this.flush();
    }

    private synchronized int write(Segment segment) throws IOException {
        int size = segment.write(this.channel);
        int left = segment.length();
        if (left == 0) {
            segment.close();
        }
        if (size < 0) {
            throw new TransportException("Socket is closed");
        }
        return size;
    }

    public synchronized boolean flush() throws IOException {
        int count = this.builder.length();
        while (count > 0) {
            Segment segment = this.builder.build();
            if (segment == null) continue;
            int size = this.write(segment);
            if (size == 0) break;
            count -= size;
        }
        if (count > 0) {
            this.builder.compact();
        }
        return count <= 0;
    }

    public synchronized void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.builder.close();
            this.channel.socket().shutdownOutput();
            this.channel.close();
        }
    }
}

