/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport.reactor;

import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.util.concurrent.Executor;
import org.simpleframework.transport.reactor.Distributor;
import org.simpleframework.transport.reactor.EventDistributor;
import org.simpleframework.transport.reactor.Operation;

class PartitionDistributor
implements Distributor {
    private final Distributor[] list;

    public PartitionDistributor(Executor executor, int count) throws IOException {
        this(executor, count, 120000L);
    }

    public PartitionDistributor(Executor executor, int count, long expiry) throws IOException {
        this.list = new Distributor[count];
        this.start(executor, expiry);
    }

    private void start(Executor executor, long expiry) throws IOException {
        for (int i = 0; i < this.list.length; ++i) {
            this.list[i] = new EventDistributor(executor, true, expiry);
        }
    }

    public void process(Operation task, int require) throws IOException {
        int length = this.list.length;
        if (length == 1) {
            this.list[0].process(task, require);
        } else {
            this.process(task, require, length);
        }
    }

    private void process(Operation task, int require, int length) throws IOException {
        SelectableChannel channel = task.getChannel();
        int hash = channel.hashCode();
        this.list[hash % length].process(task, require);
    }

    public void close() throws IOException {
        for (Distributor entry : this.list) {
            entry.close();
        }
    }
}

