/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.util.buffer;

import java.io.IOException;
import java.io.InputStream;
import org.simpleframework.util.buffer.Allocator;
import org.simpleframework.util.buffer.Buffer;
import org.simpleframework.util.buffer.BufferException;
import org.simpleframework.util.buffer.FilterAllocator;

public class BufferAllocator
extends FilterAllocator
implements Buffer {
    private Buffer buffer;

    public BufferAllocator(Allocator source) {
        super(source);
    }

    public BufferAllocator(Allocator source, int capacity) {
        super(source, capacity);
    }

    public BufferAllocator(Allocator source, int capacity, int limit) {
        super(source, capacity, limit);
    }

    public InputStream getInputStream() throws IOException {
        if (this.buffer != null) {
            this.allocate();
        }
        return this.buffer.getInputStream();
    }

    public String encode() throws IOException {
        if (this.buffer == null) {
            this.allocate();
        }
        return this.buffer.encode();
    }

    public String encode(String charset) throws IOException {
        if (this.buffer == null) {
            this.allocate();
        }
        return this.buffer.encode(charset);
    }

    public Buffer append(byte[] array) throws IOException {
        return this.append(array, 0, array.length);
    }

    public Buffer append(byte[] array, int off, int size) throws IOException {
        if (this.buffer == null) {
            this.allocate(size);
        }
        return this.buffer.append(array, off, size);
    }

    public void clear() throws IOException {
        if (this.buffer != null) {
            this.buffer.clear();
        }
    }

    public void close() throws IOException {
        if (this.buffer == null) {
            this.allocate();
        }
        this.buffer.close();
    }

    public Buffer allocate() throws IOException {
        return this.allocate(this.capacity);
    }

    public Buffer allocate(int size) throws IOException {
        if (size > this.limit) {
            throw new BufferException("Specified size %s beyond limit", size);
        }
        if (this.capacity > size) {
            size = this.capacity;
        }
        if (this.buffer == null) {
            this.buffer = this.source.allocate(size);
        }
        return this.buffer.allocate();
    }
}

