/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.core;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.simpleframework.http.core.Channel;
import org.simpleframework.http.core.Conversation;
import org.simpleframework.http.core.Entity;
import org.simpleframework.http.core.Monitor;
import org.simpleframework.http.core.Sender;
import org.simpleframework.http.core.Transfer;
import org.simpleframework.http.core.TransferException;

class Accumulator
extends OutputStream
implements WritableByteChannel {
    private Transfer transfer;
    private byte[] buffer;
    private boolean flushed;
    private boolean closed;
    private int count;

    public Accumulator(Conversation support, Entity entity, Monitor monitor) {
        this(support, entity.getChannel(), monitor);
    }

    public Accumulator(Conversation support, Channel channel, Monitor monitor) {
        this(support, channel.getSender(), monitor);
    }

    public Accumulator(Conversation support, Sender sender, Monitor monitor) {
        this.transfer = new Transfer(support, sender, monitor);
        this.buffer = new byte[0];
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public void reset() throws IOException {
        if (this.flushed) {
            throw new IOException("Respose has been flushed");
        }
        this.count = 0;
    }

    public void write(int octet) throws IOException {
        byte value = (byte)octet;
        if (this.closed) {
            throw new IOException("Response has been transferred");
        }
        this.write(new byte[]{value});
    }

    public void write(byte[] array, int off, int size) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(array, off, size);
        if (size > 0) {
            this.write(buffer);
        }
    }

    public int write(ByteBuffer source) throws IOException {
        int size;
        int mark = source.position();
        if (mark > (size = source.limit())) {
            throw new TransferException("Buffer position greater than limit");
        }
        return this.write(source, 0, size - mark);
    }

    public int write(ByteBuffer source, int off, int size) throws IOException {
        if (this.closed) {
            throw new IOException("Response has been transferred");
        }
        int mark = source.position();
        int limit = source.limit();
        if (limit - mark < size) {
            size = limit - mark;
        }
        if (this.count + size > this.buffer.length) {
            this.flush(false);
        }
        if (size > this.buffer.length) {
            this.transfer.write(source);
        } else {
            source.get(this.buffer, this.count, size);
            this.count += size;
        }
        return size;
    }

    public void expand(int capacity) throws IOException {
        if (this.buffer.length < capacity) {
            int size = this.buffer.length * 2;
            int resize = Math.max(capacity, size);
            byte[] temp = new byte[resize];
            System.arraycopy(this.buffer, 0, temp, 0, this.count);
            this.buffer = temp;
        }
    }

    public void flush() throws IOException {
        this.flush(true);
    }

    private void flush(boolean flush) throws IOException {
        if (!this.flushed) {
            this.transfer.start();
        }
        if (this.count > 0) {
            this.transfer.write(this.buffer, 0, this.count);
        }
        if (flush) {
            this.transfer.flush();
        }
        this.flushed = true;
        this.count = 0;
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.commit();
        }
        this.flushed = true;
        this.closed = true;
    }

    private void commit() throws IOException {
        if (!this.flushed) {
            this.transfer.start(this.count);
        }
        if (this.count > 0) {
            this.transfer.write(this.buffer, 0, this.count);
        }
        this.transfer.close();
    }
}

