/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.core;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.simpleframework.http.core.Monitor;
import org.simpleframework.http.core.Producer;
import org.simpleframework.http.core.ProducerException;
import org.simpleframework.http.core.Sender;

class ChunkedProducer
implements Producer {
    private byte[] size = new byte[]{48, 48, 48, 48, 48, 48, 48, 48, 13, 10};
    private byte[] index = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private byte[] zero = new byte[]{48, 13, 10, 13, 10};
    private Monitor monitor;
    private Sender sender;

    public ChunkedProducer(Sender sender, Monitor monitor) {
        this.monitor = monitor;
        this.sender = sender;
    }

    public void produce(byte[] buf) throws IOException {
        this.produce(buf, 0, buf.length);
    }

    public void produce(byte[] buf, int off, int len) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(buf, off, len);
        if (len > 0) {
            this.produce(buffer);
        }
    }

    public void produce(ByteBuffer buffer) throws IOException {
        int size;
        int mark = buffer.position();
        if (mark > (size = buffer.limit())) {
            throw new ProducerException("Buffer position greater than limit");
        }
        this.produce(buffer, 0, size - mark);
    }

    public void produce(ByteBuffer buffer, int off, int len) throws IOException {
        int pos = 7;
        if (this.monitor.isClosed()) {
            throw new ProducerException("Stream has been closed");
        }
        if (len > 0) {
            for (int num = len; num > 0; num >>>= 4) {
                this.size[pos--] = this.index[num & 0xF];
            }
            try {
                this.sender.send(this.size, pos + 1, 9 - pos);
                this.sender.send(buffer, off, len);
                this.sender.send(this.size, 8, 2);
            }
            catch (Exception cause) {
                if (this.sender != null) {
                    this.monitor.error(this.sender);
                }
                throw new ProducerException("Error sending response", cause);
            }
        }
    }

    public void flush() throws IOException {
        try {
            if (!this.monitor.isClosed()) {
                this.sender.flush();
            }
        }
        catch (Exception cause) {
            if (this.sender != null) {
                this.monitor.close(this.sender);
            }
            throw new ProducerException("Error sending response", cause);
        }
    }

    private void finish() throws IOException {
        try {
            this.sender.send(this.zero);
            this.monitor.ready(this.sender);
        }
        catch (Exception cause) {
            if (this.sender != null) {
                this.monitor.close(this.sender);
            }
            throw new ProducerException("Error flushing response", cause);
        }
    }

    public void close() throws IOException {
        if (!this.monitor.isClosed()) {
            this.finish();
        }
    }
}

