/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.core;

import java.io.IOException;
import java.io.InputStream;
import org.simpleframework.http.ContentType;
import org.simpleframework.http.Part;
import org.simpleframework.http.core.EmptyInputStream;
import org.simpleframework.http.core.LargeConsumer;
import org.simpleframework.http.core.PartList;
import org.simpleframework.http.core.Segment;
import org.simpleframework.util.buffer.Allocator;
import org.simpleframework.util.buffer.Buffer;

class ContentConsumer
extends LargeConsumer
implements Part {
    private static final byte[] START = new byte[]{13, 10, 45, 45};
    private Allocator allocator;
    private Buffer buffer;
    private Segment segment;
    private PartList list;
    private byte[] boundary;
    private int start;
    private int seek;

    public ContentConsumer(Allocator allocator, Segment segment, byte[] boundary) {
        this(allocator, segment, new PartList(), boundary);
    }

    public ContentConsumer(Allocator allocator, Segment segment, PartList list, byte[] boundary) {
        this.allocator = allocator;
        this.boundary = boundary;
        this.segment = segment;
        this.list = list;
    }

    public boolean isFile() {
        return this.segment.isFile();
    }

    public String getName() {
        return this.segment.getName();
    }

    public String getFileName() {
        return this.segment.getFileName();
    }

    public String getHeader(String name) {
        return this.segment.getValue(name);
    }

    public ContentType getContentType() {
        return this.segment.getContentType();
    }

    public String getContent() throws IOException {
        return this.buffer.encode();
    }

    public String getContent(String charset) throws IOException {
        if (this.buffer == null) {
            return new String();
        }
        return this.buffer.encode(charset);
    }

    public InputStream getInputStream() throws IOException {
        if (this.buffer == null) {
            return new EmptyInputStream();
        }
        return this.buffer.getInputStream();
    }

    protected int process(byte[] array, int off, int size) throws IOException {
        int last = off + size;
        int mark = off;
        while (off < last) {
            if (this.start == START.length) {
                if (array[off++] != this.boundary[this.seek++]) {
                    this.seek = 0;
                    this.start = 0;
                }
                if (this.seek != this.boundary.length) continue;
                int reset = this.seek + this.start;
                int excess = mark + reset;
                int length = off - excess;
                this.finished = true;
                this.list.add(this);
                this.append(array, mark, length);
                return size - length;
            }
            if (array[off++] == START[this.start++]) continue;
            if (array[off - 1] == START[0]) {
                this.start = 1;
                continue;
            }
            this.start = 0;
        }
        int reset = this.seek + this.start;
        int excess = mark + reset;
        if (reset > 0) {
            this.seek = 0;
            this.start = 0;
        }
        if (reset <= size) {
            this.append(array, mark, off - excess);
        }
        return reset;
    }

    protected Buffer allocate() throws IOException {
        if (this.buffer == null) {
            this.buffer = this.allocator.allocate();
        }
        return this.buffer;
    }

    public String toString() {
        return this.segment.toString();
    }
}

