/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.core;

import java.io.IOException;
import org.simpleframework.http.core.BodyConsumer;
import org.simpleframework.http.core.Cursor;

abstract class LargeConsumer
extends BodyConsumer {
    protected byte[] array;
    protected boolean finished;

    protected LargeConsumer() {
        this(1024);
    }

    protected LargeConsumer(int chunk) {
        this.array = new byte[chunk];
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void consume(Cursor cursor) throws IOException {
        int ready = cursor.ready();
        while (ready > 0) {
            int reset;
            int size = Math.min(ready, this.array.length);
            int count = cursor.read(this.array, 0, size);
            if (count > 0 && (reset = this.process(this.array, 0, count)) > 0) {
                cursor.reset(reset);
            }
            if (this.finished) break;
            ready = cursor.ready();
        }
    }

    protected abstract int process(byte[] var1, int var2, int var3) throws IOException;
}

