/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.core;

import java.io.IOException;
import java.io.InputStream;
import org.simpleframework.http.Part;
import org.simpleframework.http.core.BodyConsumer;
import org.simpleframework.http.core.Cursor;
import org.simpleframework.http.core.PartList;
import org.simpleframework.http.core.PartListConsumer;
import org.simpleframework.util.buffer.Allocator;

class PartFixedConsumer
extends BodyConsumer {
    private BodyConsumer consumer;
    private int remaining;
    private int repeat;

    public PartFixedConsumer(Allocator allocator, byte[] boundary, int length) {
        this.consumer = new PartListConsumer(allocator, boundary, length);
        this.remaining = length;
    }

    protected Cursor getCursor(Cursor cursor) {
        return new Limiter(cursor);
    }

    public void consume(Cursor cursor) throws IOException {
        Cursor limit = this.getCursor(cursor);
        if (this.remaining > 0) {
            this.consumer.consume(limit);
        }
    }

    public boolean isFinished() {
        return this.consumer.isFinished();
    }

    public String getContent() throws IOException {
        return this.consumer.getContent();
    }

    public String getContent(String charset) throws IOException {
        return this.consumer.getContent(charset);
    }

    public InputStream getInputStream() throws IOException {
        return this.consumer.getInputStream();
    }

    public Part getPart(String name) {
        return this.consumer.getPart(name);
    }

    public PartList getParts() {
        return this.consumer.getParts();
    }

    private class Limiter
    implements Cursor {
        private Cursor cursor;

        public Limiter(Cursor cursor) {
            this.cursor = cursor;
        }

        public boolean isOpen() throws IOException {
            return this.cursor.isOpen();
        }

        public boolean isReady() throws IOException {
            return this.ready() > 0;
        }

        public int read(byte[] data) throws IOException {
            return this.read(data, 0, data.length);
        }

        public int read(byte[] data, int off, int len) throws IOException {
            int size = Math.min(PartFixedConsumer.this.remaining, len);
            if (size <= 0) {
                return 0;
            }
            int count = this.cursor.read(data, off, size);
            if (count > 0) {
                PartFixedConsumer.this.remaining -= count;
            }
            if (PartFixedConsumer.this.remaining <= 0) {
                PartFixedConsumer.this.repeat++;
            }
            return count;
        }

        public int ready() throws IOException {
            int ready = this.cursor.ready();
            if (ready > 0) {
                return Math.min(ready, PartFixedConsumer.this.remaining);
            }
            return 0;
        }

        public int reset(int size) throws IOException {
            int reset = this.cursor.reset(size);
            if (PartFixedConsumer.this.repeat > 100) {
                throw new IOException("Failed to read final boundary");
            }
            if (reset > 0) {
                PartFixedConsumer.this.remaining += reset;
            }
            return reset;
        }
    }
}

