/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.core;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.simpleframework.http.core.Cursor;
import org.simpleframework.transport.Transport;

class TransportCursor
implements Cursor {
    private Transport transport;
    private ByteBuffer buffer;
    private boolean closed;
    private boolean reject;
    private int count;

    public TransportCursor(Transport transport) {
        this(transport, 2048);
    }

    public TransportCursor(Transport transport, int size) {
        this.buffer = ByteBuffer.allocate(size);
        this.transport = transport;
    }

    public boolean isOpen() throws IOException {
        return this.count != -1;
    }

    public boolean isReady() throws IOException {
        return this.ready() > 0;
    }

    public int read(byte[] array) throws IOException {
        return this.read(array, 0, array.length);
    }

    public int read(byte[] array, int off, int len) throws IOException {
        if (this.count <= 0) {
            return this.count;
        }
        int size = Math.min(len, this.count);
        if (size > 0) {
            this.buffer.get(array, off, size);
            this.count -= size;
        }
        return Math.max(0, size);
    }

    public int ready() throws IOException {
        if (this.count < 0) {
            return this.count;
        }
        if (this.reject) {
            this.reject = false;
            return this.peek();
        }
        if (this.count > 0) {
            return this.count;
        }
        return this.peek();
    }

    private int peek() throws IOException {
        if (this.count <= 0) {
            this.buffer.clear();
        }
        if (this.count > 0) {
            this.buffer.compact();
        }
        this.count += this.transport.read(this.buffer);
        if (this.count > 0) {
            this.buffer.flip();
        }
        if (this.count < 0) {
            this.close();
        }
        return this.count;
    }

    public int reset(int size) throws IOException {
        int mark = this.buffer.position();
        if (this.count == 0) {
            this.reject = true;
        }
        if (mark > 0) {
            this.buffer.position(mark - size);
            this.count += size;
        }
        return size;
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.transport.close();
            this.closed = true;
            this.count = -1;
        }
    }
}

