/*
 * BufferException.java February 2001
 *
 * Copyright (C) 2001, Niall Gallagher <niallg@users.sf.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General 
 * Public License along with this library; if not, write to the 
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA  02111-1307  USA
 */

package org.simpleframework.util.buffer;

import java.io.IOException;

/**
 * The <code>BufferException</code> is used to report problems that
 * can occur during the use or allocation of a buffer. Typically
 * this is thrown if the upper capacity limit is exceeded.
 *
 * @author Niall Gallagher
 */ 
public class BufferException extends IOException {

  /**
   * Constructor for the <code>BufferException</code> object. The
   * exception can be provided with a message describing the issue
   * that has arisen in the use or allocation of the buffer.
   *
   * @param format this is the template for the exception
   * @param values these are the values to be added to the template
   */         
  public BufferException(String format, Object... values) {
    super(String.format(format, values));          
  }        
}
