/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport;

import java.io.IOException;
import org.simpleframework.transport.TransportException;
import org.simpleframework.transport.reactor.Operation;
import org.simpleframework.transport.reactor.Reactor;

class Scheduler {
    private Operation task;
    private Reactor reactor;
    private Object lock;
    private volatile boolean running;

    public Scheduler(Reactor reactor, Operation task, Object lock) {
        this.reactor = reactor;
        this.task = task;
        this.lock = lock;
    }

    public void repeat() throws IOException {
        if (this.running) {
            this.reactor.process(this.task, 4);
        }
    }

    public void schedule(boolean block) throws IOException {
        if (!this.running) {
            this.reactor.process(this.task, 4);
            this.running = true;
        }
        if (block) {
            this.listen();
        }
    }

    private void listen() throws IOException {
        try {
            this.lock.wait();
        }
        catch (Exception e) {
            throw new TransportException("Schedule error", e);
        }
    }

    public void release() {
        this.lock.notifyAll();
    }

    public void ready() {
        this.lock.notifyAll();
        this.running = false;
    }
}

