/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.util.lease;

import java.util.concurrent.TimeUnit;
import org.simpleframework.util.lease.Cleaner;
import org.simpleframework.util.lease.Contract;
import org.simpleframework.util.lease.Controller;
import org.simpleframework.util.lease.Invoker;
import org.simpleframework.util.lease.LeaseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Maintainer<T>
implements Controller<T> {
    private Invoker<T> queue;

    public Maintainer(Cleaner<T> cleaner) {
        this.queue = new Invoker<T>(cleaner);
    }

    @Override
    public synchronized void issue(Contract<T> contract) throws LeaseException {
        this.queue.issue(contract);
    }

    @Override
    public synchronized void renew(Contract<T> contract) throws LeaseException {
        boolean active = this.queue.revoke(contract);
        if (!active) {
            throw new LeaseException("Lease has expired for %s", contract);
        }
        this.queue.issue(contract);
    }

    @Override
    public synchronized void cancel(Contract<T> contract) throws LeaseException {
        boolean active = this.queue.revoke(contract);
        if (!active) {
            throw new LeaseException("Lease has expired for %s", contract);
        }
        contract.setDelay(0L, TimeUnit.MILLISECONDS);
        this.queue.issue(contract);
    }

    @Override
    public synchronized void close() {
        this.queue.close();
    }
}

