/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.helpers.SubstituteLoggerFactory;
import org.slf4j.helpers.Util;
import org.slf4j.impl.StaticLoggerBinder;

public final class LoggerFactory {
    static ILoggerFactory loggerFactory;
    static final String NO_STATICLOGGERBINDER_URL = "http://www.slf4j.org/codes.html#StaticLoggerBinder";
    static final String NULL_LF_URL = "http://www.slf4j.org/codes.html#null_LF";
    static final String VERSION_MISMATCH = "http://www.slf4j.org/codes.html#version_mismatch";
    static final String SUBSTITUTE_LOGGER_URL = "http://www.slf4j.org/codes.html#substituteLogger";
    private static final String EXPECTED_VERSION = "1.5.4";

    private LoggerFactory() {
    }

    private static final void staticInitialize() {
        try {
            ArrayList loggerNameList = new ArrayList();
            loggerFactory = new SubstituteLoggerFactory(loggerNameList);
            loggerFactory = StaticLoggerBinder.SINGLETON.getLoggerFactory();
            LoggerFactory.emitSubstitureLoggerWarning(loggerNameList);
        }
        catch (NoClassDefFoundError ncde) {
            loggerFactory = null;
            String msg = ncde.getMessage();
            if (msg != null && msg.indexOf("org/slf4j/impl/StaticLoggerBinder") != -1) {
                Util.reportFailure("Failed to load class \"org.slf4j.impl.StaticLoggerBinder\".");
                Util.reportFailure("See http://www.slf4j.org/codes.html#StaticLoggerBinder for further details.");
            }
            throw ncde;
        }
        catch (Exception e) {
            loggerFactory = null;
            Util.reportFailure("Failed to instantiate logger [" + StaticLoggerBinder.SINGLETON.getLoggerFactoryClassStr() + "]", e);
        }
    }

    private static final void emitSubstitureLoggerWarning(List loggerNameList) {
        if (loggerNameList.size() == 0) {
            return;
        }
        Util.reportFailure("The following loggers will not work becasue they were created");
        Util.reportFailure("during the default configuration phase of the underlying logging system.");
        Util.reportFailure("See also http://www.slf4j.org/codes.html#substituteLogger");
        for (int i = 0; i < loggerNameList.size(); ++i) {
            String loggerName = (String)loggerNameList.get(i);
            Util.reportFailure(loggerName);
        }
    }

    private static final void versionSanityCheck() {
        try {
            String actualVer = StaticLoggerBinder.VERSION;
            if (!EXPECTED_VERSION.equals(actualVer)) {
                Util.reportFailure("The version " + actualVer + " of your slf4j-binding differs from " + EXPECTED_VERSION + ", the expected version.");
                Util.reportFailure("See http://www.slf4j.org/codes.html#version_mismatch for further details.");
            }
        }
        catch (NoSuchFieldError nsfe) {
            Util.reportFailure("The version of your slf4j-binding is probably older than 1.5.4, and differs from 1.5.4, the expected version.");
            Util.reportFailure("See http://www.slf4j.org/codes.html#version_mismatch for further details.");
        }
        catch (Throwable e) {
            Util.reportFailure("An unexpected problem occured while checking the version of your slf4j-binding");
            e.printStackTrace();
        }
    }

    public static Logger getLogger(String name) {
        if (loggerFactory == null) {
            throw new IllegalStateException("Logging factory implementation cannot be null. See also http://www.slf4j.org/codes.html#null_LF");
        }
        return loggerFactory.getLogger(name);
    }

    public static Logger getLogger(Class clazz) {
        if (loggerFactory == null) {
            throw new IllegalStateException("Logging factory implementation cannot be null. See also http://www.slf4j.org/codes.html#null_LF");
        }
        return loggerFactory.getLogger(clazz.getName());
    }

    public static ILoggerFactory getILoggerFactory() {
        return loggerFactory;
    }

    static {
        LoggerFactory.staticInitialize();
        LoggerFactory.versionSanityCheck();
    }
}

