/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.ink.log4j;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.smallmind.scribe.ink.log4j.Log4JAppenderWrapper;
import org.smallmind.scribe.ink.log4j.Log4JLevelTranslator;
import org.smallmind.scribe.ink.log4j.Log4JRecordSubverter;
import org.smallmind.scribe.pen.DefaultLogicalContext;
import org.smallmind.scribe.pen.Discriminator;
import org.smallmind.scribe.pen.Enhancer;
import org.smallmind.scribe.pen.Filter;
import org.smallmind.scribe.pen.Level;
import org.smallmind.scribe.pen.LogicalContext;
import org.smallmind.scribe.pen.Record;
import org.smallmind.scribe.pen.adapter.LoggerAdapter;
import org.smallmind.scribe.pen.probe.ProbeReport;

public class Log4JLoggerAdapter
implements LoggerAdapter {
    private Logger logger;
    private ConcurrentLinkedQueue<Filter> filterList;
    private ConcurrentLinkedQueue<Enhancer> enhancerList;
    private boolean autoFillLogicalContext = false;

    public Log4JLoggerAdapter(Logger logger) {
        this.logger = logger;
        logger.setAdditivity(false);
        this.filterList = new ConcurrentLinkedQueue();
        this.enhancerList = new ConcurrentLinkedQueue();
    }

    public String getName() {
        return this.logger.getName();
    }

    public boolean getAutoFillLogicalContext() {
        return this.autoFillLogicalContext;
    }

    public void setAutoFillLogicalContext(boolean autoFillLogicalContext) {
        this.autoFillLogicalContext = autoFillLogicalContext;
    }

    public void addFilter(Filter filter) {
        this.filterList.add(filter);
    }

    public void clearFilters() {
        this.filterList.clear();
    }

    public void addAppender(org.smallmind.scribe.pen.Appender appender) {
        this.logger.addAppender((Appender)new Log4JAppenderWrapper(appender));
    }

    public org.smallmind.scribe.pen.Appender removeAppender(org.smallmind.scribe.pen.Appender appender) {
        return this.removeAppender(appender.getName());
    }

    public org.smallmind.scribe.pen.Appender removeAppender(String name) {
        Appender appender = this.logger.getAppender(name);
        if (appender != null) {
            this.logger.removeAppender(name);
            if (appender instanceof Log4JAppenderWrapper) {
                return ((Log4JAppenderWrapper)appender).getInnerAppender();
            }
            throw new UnsupportedOperationException("Appender can't be returned via this interface because it's Log4J native");
        }
        return null;
    }

    public void clearAppenders() {
        this.logger.removeAllAppenders();
    }

    public void addEnhancer(Enhancer enhancer) {
        this.enhancerList.add(enhancer);
    }

    public void clearEnhancers() {
        this.enhancerList.clear();
    }

    public Level getLevel() {
        return this.logger.getLevel() == null ? Level.INFO : Log4JLevelTranslator.getLevel(this.logger.getLevel());
    }

    public void setLevel(Level level) {
        this.logger.setLevel(Log4JLevelTranslator.getLog4JLevel(level));
    }

    public void logMessage(Discriminator discriminator, Level level, Throwable throwable, String message, Object ... args) {
        LogicalContext logicalContext;
        if (!level.equals((Object)Level.OFF) && this.getLevel().noGreater(level) && (logicalContext = this.willLog(discriminator, level)) != null) {
            Log4JRecordSubverter recordSubverter = new Log4JRecordSubverter(this.logger, discriminator, level, null, logicalContext, throwable, message, args);
            this.enhanceRecord(recordSubverter.getRecord());
            this.logger.callAppenders((LoggingEvent)recordSubverter);
        }
    }

    public void logProbe(Discriminator discriminator, Level level, Throwable throwable, ProbeReport probeReport) {
        LogicalContext logicalContext;
        if (!level.equals((Object)Level.OFF) && this.getLevel().noGreater(level) && (logicalContext = this.willLog(discriminator, level)) != null) {
            Log4JRecordSubverter recordSubverter = new Log4JRecordSubverter(this.logger, discriminator, level, probeReport, logicalContext, throwable, probeReport.getTitle() == null ? "Probe Report" : probeReport.getTitle(), new Object[0]);
            this.enhanceRecord(recordSubverter.getRecord());
            this.logger.callAppenders((LoggingEvent)recordSubverter);
        }
    }

    public void logMessage(Discriminator discriminator, Level level, Throwable throwable, Object object) {
        LogicalContext logicalContext;
        if (!level.equals((Object)Level.OFF) && this.getLevel().noGreater(level) && (logicalContext = this.willLog(discriminator, level)) != null) {
            Log4JRecordSubverter recordSubverter = new Log4JRecordSubverter(this.logger, discriminator, level, null, logicalContext, throwable, object == null ? null : object.toString(), new Object[0]);
            this.enhanceRecord(recordSubverter.getRecord());
            this.logger.callAppenders((LoggingEvent)recordSubverter);
        }
    }

    private LogicalContext willLog(Discriminator discriminator, Level level) {
        DefaultLogicalContext logicalContext = new DefaultLogicalContext();
        if (this.getAutoFillLogicalContext()) {
            logicalContext.fillIn();
        }
        if (!this.filterList.isEmpty()) {
            Record filterRecord = new Log4JRecordSubverter(this.logger, discriminator, level, null, (LogicalContext)logicalContext, null, null, new Object[0]).getRecord();
            for (Filter filter : this.filterList) {
                if (filter.willLog(filterRecord)) continue;
                return null;
            }
        }
        return logicalContext;
    }

    private void enhanceRecord(Record record) {
        for (Enhancer enhancer : this.enhancerList) {
            enhancer.enhance(record);
        }
    }
}

