/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.ink.log4j;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.smallmind.scribe.ink.log4j.Log4JLevelTranslator;
import org.smallmind.scribe.pen.Discriminator;
import org.smallmind.scribe.pen.Level;
import org.smallmind.scribe.pen.LogicalContext;
import org.smallmind.scribe.pen.MessageTranslator;
import org.smallmind.scribe.pen.Parameter;
import org.smallmind.scribe.pen.Record;
import org.smallmind.scribe.pen.SequenceGenerator;
import org.smallmind.scribe.pen.adapter.RecordWrapper;
import org.smallmind.scribe.pen.probe.ProbeReport;

public class Log4JRecordSubverter
extends LoggingEvent
implements RecordWrapper {
    private static final Parameter[] NO_PARAMETERS = new Parameter[0];
    private Log4JRecord log4jRecord;
    private ProbeReport probeReport;
    private LogicalContext logicalContext;
    private AtomicReference<LocationInfo> locationInfoReference;
    private Discriminator discriminator;
    private Level level;

    public Log4JRecordSubverter(Logger logger, Discriminator discriminator, Level level, ProbeReport probeReport, LogicalContext logicalContext, Throwable throwable, String message, Object ... args) {
        super(logger.getClass().getCanonicalName(), (Category)logger, System.currentTimeMillis(), (Priority)Log4JLevelTranslator.getLog4JLevel(level), (Object)MessageTranslator.translateMessage((String)message, (Object[])args), throwable);
        this.discriminator = discriminator;
        this.level = level;
        this.probeReport = probeReport;
        this.logicalContext = logicalContext;
        this.log4jRecord = new Log4JRecord(this);
        this.locationInfoReference = new AtomicReference();
    }

    public Record getRecord() {
        return this.log4jRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocationInfo getLocationInformation() {
        if (this.locationInfoReference.get() == null) {
            Log4JRecordSubverter log4JRecordSubverter = this;
            synchronized (log4JRecordSubverter) {
                if (this.locationInfoReference.get() == null && this.logicalContext != null) {
                    this.locationInfoReference.set(new LocationInfo(this.logicalContext.getFileName(), this.logicalContext.getClassName(), this.logicalContext.getMethodName(), String.valueOf(this.logicalContext.getLineNumber())));
                }
            }
        }
        return this.locationInfoReference.get();
    }

    private class Log4JRecord
    implements Record {
        private LoggingEvent loggingEvent;
        private HashMap<String, Serializable> parameterMap;
        private long threadId;
        private long sequenceNumber;

        public Log4JRecord(LoggingEvent loggingEvent) {
            this.loggingEvent = loggingEvent;
            this.parameterMap = new HashMap();
            this.threadId = Thread.currentThread().getId();
            this.sequenceNumber = SequenceGenerator.next();
        }

        public Object getNativeLogEntry() {
            return this.loggingEvent;
        }

        public ProbeReport getProbeReport() {
            return Log4JRecordSubverter.this.probeReport;
        }

        public String getLoggerName() {
            return this.loggingEvent.getLoggerName();
        }

        public Discriminator getDiscriminator() {
            return Log4JRecordSubverter.this.discriminator;
        }

        public Level getLevel() {
            return Log4JRecordSubverter.this.level;
        }

        public Throwable getThrown() {
            return this.loggingEvent.getThrowableInformation() != null ? this.loggingEvent.getThrowableInformation().getThrowable() : null;
        }

        public String getMessage() {
            return this.loggingEvent.getRenderedMessage();
        }

        public void addParameter(String key, Serializable value) {
            this.parameterMap.put(key, value);
        }

        public Parameter[] getParameters() {
            if (this.parameterMap.isEmpty()) {
                return NO_PARAMETERS;
            }
            int index = 0;
            Parameter[] parameters = new Parameter[this.parameterMap.size()];
            for (Map.Entry<String, Serializable> entry : this.parameterMap.entrySet()) {
                parameters[index++] = new Parameter(entry.getKey(), entry.getValue());
            }
            return parameters;
        }

        public LogicalContext getLogicalContext() {
            return Log4JRecordSubverter.this.logicalContext;
        }

        public long getThreadID() {
            return this.threadId;
        }

        public String getThreadName() {
            return this.loggingEvent.getThreadName();
        }

        public long getSequenceNumber() {
            return this.sequenceNumber;
        }

        public long getMillis() {
            return this.loggingEvent.getTimeStamp();
        }
    }
}

