/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.pen;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.smallmind.nutsnbolts.io.PathUtility;
import org.smallmind.scribe.pen.CleanupRule;
import org.smallmind.scribe.pen.LoggerException;

public class Cleanup {
    private CleanupRule[] rules;
    private char separator;

    public Cleanup() {
    }

    public Cleanup(CleanupRule ... rules) {
        this('-', rules);
    }

    public Cleanup(char separator, CleanupRule ... rules) {
        this.separator = separator;
        this.rules = rules;
    }

    public char getSeparator() {
        return this.separator;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public void setRules(CleanupRule[] rules) {
        this.rules = rules;
    }

    public void vacuum(Path logPath) throws IOException, LoggerException {
        String prologue;
        String epilogue = null;
        CleanupRule[] copyRules = new CleanupRule[this.rules == null ? 0 : this.rules.length];
        int index = 0;
        while (index < copyRules.length) {
            copyRules[index] = this.rules[index].copy();
            ++index;
        }
        String logFileName = PathUtility.fileNameAsString((Path)logPath);
        int dotPos = logFileName.lastIndexOf(46);
        if (dotPos >= 0) {
            prologue = String.valueOf(logFileName.substring(0, dotPos)) + this.separator;
            epilogue = logFileName.substring(dotPos);
        } else {
            prologue = String.valueOf(logFileName) + this.separator;
        }
        Throwable throwable = null;
        Object var9_10 = null;
        try {
            Path parentPath = logPath.getParent();
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(parentPath == null ? Paths.get("/", new String[0]) : parentPath);){
                block6: for (Path possiblePath : directoryStream) {
                    String possibleFileName;
                    if (!Files.isRegularFile(possiblePath, new LinkOption[0]) || possiblePath.equals(logPath) || !(possibleFileName = PathUtility.fileNameAsString((Path)possiblePath)).startsWith(prologue) || epilogue != null && !possibleFileName.endsWith(epilogue)) continue;
                    CleanupRule[] cleanupRuleArray = copyRules;
                    int n = copyRules.length;
                    int n2 = 0;
                    while (n2 < n) {
                        CleanupRule rule = cleanupRuleArray[n2];
                        if (rule.willCleanup(possiblePath)) {
                            Files.deleteIfExists(possiblePath);
                            continue block6;
                        }
                        ++n2;
                    }
                }
                CleanupRule[] cleanupRuleArray = copyRules;
                int n = copyRules.length;
                int n3 = 0;
                while (n3 < n) {
                    CleanupRule rule = cleanupRuleArray[n3];
                    rule.finish();
                    ++n3;
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

