/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.pen;

import java.util.Date;
import org.smallmind.scribe.pen.DateFormatTimestamp;
import org.smallmind.scribe.pen.RolloverRule;
import org.smallmind.scribe.pen.Timestamp;

public class Rollover {
    private RolloverRule[] rules;
    private Timestamp timestamp;
    private char separator;

    public Rollover() {
    }

    public Rollover(RolloverRule ... rules) {
        this((Timestamp)DateFormatTimestamp.getDefaultInstance(), rules);
    }

    public Rollover(Timestamp timestamp, RolloverRule ... rules) {
        this(timestamp, '-', rules);
    }

    public Rollover(Timestamp timestamp, char separator, RolloverRule ... rules) {
        this.timestamp = timestamp;
        this.separator = separator;
        this.rules = rules;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
    }

    public char getSeparator() {
        return this.separator;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public String getTimestampSuffix(Date date) {
        return this.timestamp.getTimestamp(date);
    }

    public void setRules(RolloverRule[] rules) {
        this.rules = rules;
    }

    public boolean willRollover(long fileSize, long lastModified, long bytesToBeWritten) {
        RolloverRule[] rolloverRuleArray = this.rules;
        int n = this.rules.length;
        int n2 = 0;
        while (n2 < n) {
            RolloverRule rule = rolloverRuleArray[n2];
            if (rule.willRollover(fileSize, lastModified, bytesToBeWritten)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

