/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.scribe.spring;

import java.util.HashMap;
import org.smallmind.nutsnbolts.spring.SpringPropertyAccessor;
import org.smallmind.nutsnbolts.spring.SpringPropertyAccessorManager;
import org.smallmind.scribe.pen.Appender;
import org.smallmind.scribe.pen.ClassNameTemplate;
import org.smallmind.scribe.pen.Enhancer;
import org.smallmind.scribe.pen.Filter;
import org.smallmind.scribe.pen.Level;
import org.smallmind.scribe.pen.LoggerException;
import org.springframework.beans.factory.InitializingBean;

public class DynamicClassNameTemplateInitializingBean
implements InitializingBean {
    private Filter[] filters = new Filter[0];
    private Appender[] appenders = new Appender[0];
    private Enhancer[] enhancers = new Enhancer[0];
    private boolean autoFillLogicalContext = false;

    public void setFilters(Filter[] filters) {
        this.filters = filters;
    }

    public void setAppenders(Appender[] appenders) {
        this.appenders = appenders;
    }

    public void setEnhancers(Enhancer[] enhancers) {
        this.enhancers = enhancers;
    }

    public void setAutoFillLogicalContext(boolean autoFillLogicalContext) {
        this.autoFillLogicalContext = autoFillLogicalContext;
    }

    public void afterPropertiesSet() throws Exception {
        HashMap<String, String> templateMap = new HashMap<String, String>();
        HashMap<String, String> levelMap = new HashMap<String, String>();
        SpringPropertyAccessor springPropertyAccessor = SpringPropertyAccessorManager.getSpringPropertyAccessor();
        for (String propertyKey : springPropertyAccessor.getKeySet()) {
            if (propertyKey.startsWith("log.pattern.")) {
                templateMap.put(propertyKey.substring("log.pattern.".length()), springPropertyAccessor.asString(propertyKey));
            }
            if (!propertyKey.startsWith("log.level.")) continue;
            levelMap.put(propertyKey.substring("log.level.".length()), springPropertyAccessor.asString(propertyKey));
        }
        for (String logKey : templateMap.keySet()) {
            String levelValue = (String)levelMap.get(logKey);
            if (levelValue == null) {
                throw new LoggerException("Undefined level for log key(%s)", new Object[]{logKey});
            }
            ClassNameTemplate classNameTemplate = new ClassNameTemplate(this.filters, this.appenders, this.enhancers, Level.valueOf((String)levelValue), this.autoFillLogicalContext, (String)templateMap.get(logKey));
            classNameTemplate.register();
        }
    }
}

