/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.jersey.util;

import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.annotation.XmlRootElement;
import org.smallmind.web.jersey.util.JAXBProcessingException;
import org.smallmind.web.jersey.util.XmlPolymorphicSubClasses;

public class PolymorphicClassCache {
    private static final ConcurrentHashMap<Class<?>, Class<?>> TO_PROXY_CLASS_MAP = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Class<?>, Class<?>> FROM_PROXY_CLASS_MAP = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Class<?>, HashMap<String, Class<?>>> SUB_CLASS_MAP = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?> getPolymorphicSubClass(Class<?> baseClass, String polymorphicKey) {
        HashMap<String, Class<Object>> polymorphicKeyMap = SUB_CLASS_MAP.get(baseClass);
        if (polymorphicKeyMap == null) {
            ConcurrentHashMap<Class<?>, HashMap<String, Class<?>>> concurrentHashMap = SUB_CLASS_MAP;
            synchronized (concurrentHashMap) {
                polymorphicKeyMap = SUB_CLASS_MAP.get(baseClass);
                if (polymorphicKeyMap == null) {
                    XmlPolymorphicSubClasses xmlPolymorphicSubClassesAnnotation = baseClass.getAnnotation(XmlPolymorphicSubClasses.class);
                    if (xmlPolymorphicSubClassesAnnotation == null) {
                        throw new JAXBProcessingException("The class(%s) is missing a %s annotation", baseClass.getName(), XmlPolymorphicSubClasses.class.getSimpleName());
                    }
                    polymorphicKeyMap = new HashMap();
                    SUB_CLASS_MAP.put(baseClass, polymorphicKeyMap);
                    Class[] classArray = xmlPolymorphicSubClassesAnnotation.value();
                    int n = classArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Class polymorphicSubClass = classArray[n2];
                        XmlRootElement xmlRootElementAnnotation = polymorphicSubClass.getAnnotation(XmlRootElement.class);
                        if (xmlRootElementAnnotation == null) {
                            throw new JAXBProcessingException("The sub-class(%s) is missing a %s annotation", polymorphicSubClass.getName(), XmlRootElement.class.getSimpleName());
                        }
                        polymorphicKeyMap.put(xmlRootElementAnnotation.name(), polymorphicSubClass);
                        ++n2;
                    }
                }
            }
        }
        return polymorphicKeyMap.get(polymorphicKey);
    }

    public static void addClassRelationship(Class<?> polymorphicSubClass, Class<?> proxySubClass) {
        TO_PROXY_CLASS_MAP.putIfAbsent(polymorphicSubClass, proxySubClass);
        FROM_PROXY_CLASS_MAP.putIfAbsent(proxySubClass, polymorphicSubClass);
    }

    public static Class<?> getProxyClassForPolymorphicClass(Class<?> polymorphicSubClass) {
        return TO_PROXY_CLASS_MAP.get(polymorphicSubClass);
    }

    public static Class<?> getPolymorphicClassForProxyClass(Class<?> proxySubClass) {
        return FROM_PROXY_CLASS_MAP.get(proxySubClass);
    }
}

