/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.jwt;

import java.security.Key;
import org.smallmind.nutsnbolts.security.HMACSigningAlgorithm;
import org.smallmind.nutsnbolts.security.RSASigningAlgorithm;

public enum JWTEncryptionAlgorithm {
    HS256{

        @Override
        public byte[] encrypt(Key key, String prologue) throws Exception {
            return HMACSigningAlgorithm.HMAC_SHA_256.sign(key, prologue.getBytes());
        }

        @Override
        public boolean verify(Key key, String[] pieces, boolean urlSafe) throws Exception {
            return HMACSigningAlgorithm.HMAC_SHA_256.verify(key, pieces, urlSafe);
        }
    }
    ,
    RS256{

        @Override
        public byte[] encrypt(Key key, String prologue) throws Exception {
            return RSASigningAlgorithm.SHA_256_WITH_RSA.sign(key, prologue.getBytes());
        }

        @Override
        public boolean verify(Key key, String[] pieces, boolean urlSafe) throws Exception {
            return RSASigningAlgorithm.SHA_256_WITH_RSA.verify(key, pieces, urlSafe);
        }
    };


    public abstract byte[] encrypt(Key var1, String var2) throws Exception;

    public abstract boolean verify(Key var1, String[] var2, boolean var3) throws Exception;
}

