/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.websocket;

import java.util.concurrent.ThreadLocalRandom;
import org.smallmind.web.websocket.Fragment;
import org.smallmind.web.websocket.OpCode;
import org.smallmind.web.websocket.SyntaxException;
import org.smallmind.web.websocket.WebSocketException;

public class Frame {
    public static byte[] ping(byte[] message) throws WebSocketException {
        return Frame.control(OpCode.PING, message);
    }

    public static byte[] pong(byte[] message) throws WebSocketException {
        return Frame.control(OpCode.PONG, message);
    }

    public static byte[] close(byte[] status, String reason) throws WebSocketException {
        byte[] message;
        if (reason == null) {
            message = status;
        } else {
            byte[] reasonsBytes = reason.getBytes();
            message = new byte[reasonsBytes.length + 2];
            System.arraycopy(status, 0, message, 0, 2);
            System.arraycopy(reasonsBytes, 0, message, 2, reasonsBytes.length);
        }
        return Frame.control(OpCode.CLOSE, message);
    }

    private static byte[] control(OpCode opCode, byte[] message) throws WebSocketException {
        if (message.length > 125) {
            throw new WebSocketException("Control frame data length exceeds 125 bytes", new Object[0]);
        }
        return Frame.data(opCode, message);
    }

    public static byte[] text(String message) {
        return Frame.data(OpCode.TEXT, message.getBytes());
    }

    public static byte[] binary(byte[] message) {
        return Frame.data(OpCode.BINARY, message);
    }

    private static byte[] data(OpCode opCode, byte[] message) {
        int start = message.length < 126 ? 6 : (message.length < 65536 ? 8 : 14);
        byte[] out = new byte[message.length + start];
        byte[] mask = new byte[4];
        ThreadLocalRandom.current().nextBytes(mask);
        out[0] = (byte)(0x80 | opCode.getCode());
        if (message.length < 126) {
            out[1] = (byte)(0x80 | message.length);
            System.arraycopy(mask, 0, out, 2, 4);
        } else if (message.length < 65536) {
            out[1] = -2;
            out[2] = (byte)(message.length >>> 8);
            out[3] = (byte)(message.length & 0xFF);
            System.arraycopy(mask, 0, out, 4, 4);
        } else {
            out[1] = -1;
            out[2] = 0;
            out[3] = 0;
            out[4] = 0;
            out[5] = 0;
            out[6] = (byte)(message.length >>> 24);
            out[7] = (byte)(message.length >>> 16);
            out[8] = (byte)(message.length >>> 8);
            out[9] = (byte)(message.length & 0xFF);
            System.arraycopy(mask, 0, out, 10, 4);
        }
        for (int index = 0; index < message.length; ++index) {
            out[index + start] = (byte)(message[index] ^ mask[index % 4]);
        }
        return out;
    }

    public static Fragment decode(byte[] buffer) throws SyntaxException {
        byte[] message;
        int start;
        OpCode opCode = OpCode.convert(buffer[0]);
        if (opCode == null) {
            throw new SyntaxException("Unknown op code(%d)", buffer[0] & 0xF);
        }
        boolean fin = (buffer[0] & 0x80) != 0;
        byte length = (byte)(buffer[1] & 0x7F);
        if (length < 126) {
            start = 2;
            message = new byte[length];
        } else if (length == 126) {
            message = new byte[((buffer[2] & 0xFF) << 8) + (buffer[3] & 0xFF)];
            start = 4;
        } else {
            message = new byte[((buffer[6] & 0xFF) << 24) + ((buffer[7] & 0xFF) << 16) + ((buffer[8] & 0xFF) << 8) + (buffer[9] & 0xFF)];
            start = 10;
        }
        System.arraycopy(buffer, start, message, 0, message.length);
        return new Fragment(fin, opCode, message);
    }
}

