/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.websocket.spi;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.websocket.ClientEndpoint;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.Decoder;
import javax.websocket.DeploymentException;
import javax.websocket.Encoder;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.Session;

public class AnnotatedEndpoint
extends Endpoint {
    private final AnnotatedClientEndpointConfig endpointConfig;

    public AnnotatedEndpoint(Class<?> annotatedClass) throws DeploymentException {
        ClientEndpoint clientEndpointAnnotation = annotatedClass.getAnnotation(ClientEndpoint.class);
        if (clientEndpointAnnotation == null) {
            throw new DeploymentException("Missing the required ClientEndpoint annotation");
        }
        try {
            this.endpointConfig = new AnnotatedClientEndpointConfig(clientEndpointAnnotation);
        }
        catch (IllegalAccessException | InstantiationException exception) {
            throw new DeploymentException("Unable to to instantiate the client endpoint configuration", (Throwable)exception);
        }
    }

    public AnnotatedClientEndpointConfig getEndpointConfig() {
        return this.endpointConfig;
    }

    public void onOpen(Session session, EndpointConfig config) {
    }

    private class AnnotatedClientEndpointConfig
    implements ClientEndpointConfig {
        private final ClientEndpoint clientEndpoint;
        private final ClientEndpointConfig.Configurator configurator;
        private final HashMap<String, Object> userProperties = new HashMap();

        public AnnotatedClientEndpointConfig(ClientEndpoint clientEndpoint) throws InstantiationException, IllegalAccessException {
            this.clientEndpoint = clientEndpoint;
            this.configurator = (ClientEndpointConfig.Configurator)clientEndpoint.configurator().newInstance();
        }

        public List<String> getPreferredSubprotocols() {
            return Arrays.asList(this.clientEndpoint.subprotocols());
        }

        public List<Extension> getExtensions() {
            return null;
        }

        public ClientEndpointConfig.Configurator getConfigurator() {
            return this.configurator;
        }

        public List<Class<? extends Encoder>> getEncoders() {
            return Arrays.asList(this.clientEndpoint.encoders());
        }

        public List<Class<? extends Decoder>> getDecoders() {
            return Arrays.asList(this.clientEndpoint.decoders());
        }

        public Map<String, Object> getUserProperties() {
            return this.userProperties;
        }
    }
}

