/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.websocket.spi;

import java.util.List;
import java.util.Map;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.HandshakeResponse;
import org.smallmind.nutsnbolts.util.Tuple;
import org.smallmind.web.websocket.HandshakeListener;

public class ConfiguratorHandshakeListener
implements HandshakeListener {
    private ClientEndpointConfig.Configurator configurator;

    public ConfiguratorHandshakeListener(ClientEndpointConfig.Configurator configurator) {
        this.configurator = configurator;
    }

    @Override
    public void beforeRequest(Tuple<String, String> headerTuple) {
        Map headerMap = headerTuple.asMap();
        this.configurator.beforeRequest(headerMap);
        headerTuple.clear();
        for (Map.Entry entry : headerMap.entrySet()) {
            List valueList = (List)entry.getValue();
            if (valueList == null || valueList.isEmpty()) continue;
            for (String value : valueList) {
                headerTuple.addPair(entry.getKey(), (Object)value);
            }
        }
    }

    @Override
    public void afterResponse(final Tuple<String, String> headerTuple) {
        this.configurator.afterResponse(new HandshakeResponse(){

            public Map<String, List<String>> getHeaders() {
                return headerTuple.asMap();
            }
        });
    }
}

