/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.common.util;

import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class HiveTestUtils {
    public static final Log LOG = LogFactory.getLog(HiveTestUtils.class);
    public static final String JAVA_FILE_EXT = ".java";
    public static final String CLAZZ_FILE_EXT = ".class";
    public static final String JAR_FILE_EXT = ".jar";
    public static final String TXT_FILE_EXT = ".txt";

    public static String getFileFromClasspath(String name) {
        URL url = ClassLoader.getSystemResource(name);
        if (url == null) {
            throw new IllegalArgumentException("Could not find " + name);
        }
        return url.getPath();
    }

    private static void executeCmd(String[] cmdArr, File dir) throws IOException, InterruptedException {
        final Process p1 = Runtime.getRuntime().exec(cmdArr, null, dir);
        new Thread(new Runnable(){

            @Override
            public void run() {
                BufferedReader input = new BufferedReader(new InputStreamReader(p1.getErrorStream()));
                try {
                    String line;
                    while ((line = input.readLine()) != null) {
                        System.out.println(line);
                    }
                }
                catch (IOException e) {
                    LOG.error((Object)("Failed to execute the command due the exception " + e));
                }
            }
        }).start();
        p1.waitFor();
    }

    public static File genLocalJarForTest(String pathToClazzFile, String clazzName) throws IOException, InterruptedException {
        String u = pathToClazzFile;
        File dir = new File(u);
        File parentDir = dir.getParentFile();
        File f = new File(parentDir, clazzName + JAVA_FILE_EXT);
        Files.copy((File)dir, (File)f);
        HiveTestUtils.executeCmd(new String[]{"javac", clazzName + JAVA_FILE_EXT}, parentDir);
        HiveTestUtils.executeCmd(new String[]{"jar", "cf", clazzName + JAR_FILE_EXT, clazzName + CLAZZ_FILE_EXT}, parentDir);
        f.delete();
        new File(parentDir, clazzName + CLAZZ_FILE_EXT).delete();
        return new File(parentDir, clazzName + JAR_FILE_EXT);
    }
}

