/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.maven;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.AbstractRepositoryListener;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.filter.DependencyFilterUtils;
import org.eclipse.aether.version.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.maven.ClassifierDependencyFilter;

public final class MavenRepositoryUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MavenRepositoryUtils.class);

    private MavenRepositoryUtils() {
    }

    public static String toPath(Collection<File> files) {
        StringBuilder result = new StringBuilder(files.size() * 20);
        Iterator<File> iterator = files.iterator();
        if (iterator.hasNext()) {
            result.append(iterator.next().getAbsolutePath());
        } else {
            return "";
        }
        while (iterator.hasNext()) {
            result.append(File.pathSeparatorChar);
            result.append(iterator.next().getAbsolutePath());
        }
        return StringUtils.quoteAndEscape((String)result.toString(), (char)'\'');
    }

    @Nonnull
    public static RepositorySystem getRepositorySystem() {
        DefaultServiceLocator serviceLocator = MavenRepositorySystemUtils.newServiceLocator();
        serviceLocator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        serviceLocator.addService(TransporterFactory.class, FileTransporterFactory.class);
        serviceLocator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        serviceLocator.setErrorHandler(new DefaultServiceLocator.ErrorHandler(){

            public void serviceCreationFailed(Class<?> type, Class<?> impl, Throwable exception) {
                LOG.error("Error creating service {}, {}", new Object[]{type, impl, exception});
            }
        });
        RepositorySystem service = (RepositorySystem)serviceLocator.getService(RepositorySystem.class);
        if (service == null) {
            throw new IllegalStateException("No repository system in " + serviceLocator);
        }
        return service;
    }

    public static RepositorySystemSession getRepositorySystemSession(RepositorySystem system, File localRepoPath) {
        DefaultRepositorySystemSession repositorySystemSession = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepository = new LocalRepository(localRepoPath);
        repositorySystemSession.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)repositorySystemSession, localRepository));
        repositorySystemSession.setRepositoryListener((RepositoryListener)new AbstractRepositoryListener(){

            public void artifactDownloaded(RepositoryEvent event) {
                LOG.info("Downloaded artifact {}", (Object)event);
            }
        });
        return repositorySystemSession;
    }

    public static RemoteRepository getDefaultRepository() {
        return new RemoteRepository.Builder("central", "default", System.getProperty("spf4j.jdiff.defaultMavenRepo", "http://central.maven.org/maven2/")).build();
    }

    public static List<Version> getVersions(List<RemoteRepository> repos, File localRepo, String groupId, String artifactId, String versionExpr) throws VersionRangeResolutionException {
        RepositorySystem repositorySystem = MavenRepositoryUtils.getRepositorySystem();
        RepositorySystemSession session = MavenRepositoryUtils.getRepositorySystemSession(repositorySystem, localRepo);
        return MavenRepositoryUtils.getVersions(groupId, artifactId, versionExpr, repos, repositorySystem, session);
    }

    public static List<Version> getVersions(String groupId, String artifactId, String versionExpr, List<RemoteRepository> repos, RepositorySystem repositorySystem, RepositorySystemSession session) throws VersionRangeResolutionException {
        DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, null, null, versionExpr);
        VersionRangeRequest request = new VersionRangeRequest((Artifact)artifact, repos, null);
        VersionRangeResult versionResult = repositorySystem.resolveVersionRange(session, request);
        return versionResult.getVersions();
    }

    public static File resolveArtifact(List<RemoteRepository> repos, File localRepo, String groupId, String artifactId, String classifier, String extension, String versionExpr) throws ArtifactResolutionException {
        RepositorySystem repositorySystem = MavenRepositoryUtils.getRepositorySystem();
        RepositorySystemSession session = MavenRepositoryUtils.getRepositorySystemSession(repositorySystem, localRepo);
        return MavenRepositoryUtils.resolveArtifact(groupId, artifactId, classifier, extension, versionExpr, repos, repositorySystem, session);
    }

    public static File resolveArtifact(String groupId, String artifactId, String classifier, String extension, String versionExpr, List<RemoteRepository> repos, RepositorySystem repositorySystem, RepositorySystemSession session) throws ArtifactResolutionException {
        DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, classifier, extension, versionExpr);
        ArtifactRequest artifactRequest = new ArtifactRequest();
        artifactRequest.setArtifact((Artifact)artifact);
        artifactRequest.setRepositories(repos);
        ArtifactResult artifactResult = repositorySystem.resolveArtifact(session, artifactRequest);
        artifact = artifactResult.getArtifact();
        return artifact.getFile();
    }

    public static Set<File> resolveArtifactAndDependencies(List<RemoteRepository> repos, File localRepo, String scope, String groupId, String artifactId, String classifier, String extension, String versionExpr) throws DependencyResolutionException {
        RepositorySystem repositorySystem = MavenRepositoryUtils.getRepositorySystem();
        RepositorySystemSession session = MavenRepositoryUtils.getRepositorySystemSession(repositorySystem, localRepo);
        return MavenRepositoryUtils.resolveArtifactAndDependencies(scope, groupId, artifactId, classifier, extension, versionExpr, repos, repositorySystem, session);
    }

    public static Set<File> resolveArtifactAndDependencies(String scope, String groupId, String artifactId, String classifier, String extension, String versionExpr, List<RemoteRepository> repos, RepositorySystem repositorySystem, RepositorySystemSession session) throws DependencyResolutionException {
        DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, classifier, extension, versionExpr);
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(new Dependency((Artifact)artifact, scope));
        collectRequest.setRepositories(repos);
        DependencyFilter dependencyFilter = DependencyFilterUtils.classpathFilter((String[])new String[]{scope});
        if (classifier != null) {
            dependencyFilter = DependencyFilterUtils.andFilter((DependencyFilter[])new DependencyFilter[]{new ClassifierDependencyFilter(classifier)});
        }
        DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, dependencyFilter);
        DependencyResult depresult = repositorySystem.resolveDependencies(session, dependencyRequest);
        List artifactResults = depresult.getArtifactResults();
        HashSet result = Sets.newHashSetWithExpectedSize((int)artifactResults.size());
        for (ArtifactResult ar : artifactResults) {
            result.add(ar.getArtifact().getFile());
        }
        return result;
    }
}

