/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.jdiff;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.DefaultConsumer;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.spf4j.jdiff.JavadocExecutionException;

public final class JavadocExecutor {
    private Commandline cmd = new Commandline();

    public JavadocExecutor() {
        this(System.getProperty("java.home") + "/javadoc");
    }

    public JavadocExecutor(String executable) {
        this.cmd.setExecutable(executable);
    }

    public void addArgumentPair(String argKey, String argValue) {
        this.cmd.createArg().setValue("-" + argKey);
        this.cmd.createArg().setValue(argValue);
    }

    public void addArgument(String arg) {
        this.cmd.createArg().setValue(arg);
    }

    public void execute(File dir) throws JavadocExecutionException, IOException {
        if (!dir.exists()) {
            Files.createDirectories(dir.toPath(), new FileAttribute[0]);
        }
        this.cmd.setWorkingDirectory(dir.getAbsolutePath());
        int exitCode = 0;
        try {
            exitCode = CommandLineUtils.executeCommandLine((Commandline)this.cmd, (StreamConsumer)new DefaultConsumer(), (StreamConsumer)new DefaultConsumer());
        }
        catch (Exception ex) {
            throw new JavadocExecutionException("generateJDiff doclet failed: " + this.cmd, ex);
        }
        if (exitCode != 0) {
            throw new JavadocExecutionException("generate JDiff doclet " + this.cmd + " failed with exit code " + exitCode);
        }
    }

    public String toString() {
        return "JavadocExecutor{cmd=" + this.cmd + '}';
    }
}

