/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.log;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.encoder.EncoderBase;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.avro.AvroNamesRefResolver;
import org.apache.avro.Schema;
import org.apache.avro.SchemaResolvers;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ExtendedJsonEncoder;
import org.apache.avro.specific.ExtendedSpecificDatumWriter;
import org.apache.avro.util.Arrays;
import org.spf4j.base.Json;
import org.spf4j.base.Runtime;
import org.spf4j.base.Strings;
import org.spf4j.base.avro.LogRecord;
import org.spf4j.io.ByteArrayBuilder;
import org.spf4j.log.Converters;

public final class AvroLogbackEncoder
extends EncoderBase<ILoggingEvent> {
    private static final MinimalPrettyPrinter JSON_FMT = new MinimalPrettyPrinter(Strings.EOL){

        public void writeArrayValueSeparator(JsonGenerator jg) throws IOException {
            jg.writeRaw(',');
            jg.writeRaw(Strings.EOL);
            jg.writeRaw('\t');
        }

        public void beforeArrayValues(JsonGenerator jg) throws IOException {
            jg.writeRaw(Strings.EOL);
            jg.writeRaw('\t');
        }
    };
    private final ByteArrayBuilder bab;
    private final DatumWriter writer;
    private Encoder encoder;
    private Charset charset = Charset.defaultCharset();

    public AvroLogbackEncoder() {
        this.bab = new ByteArrayBuilder(128);
        this.writer = new ExtendedSpecificDatumWriter(LogRecord.class);
        this.initEncoder();
    }

    public void setCharset(String charsetName) {
        this.charset = Charset.forName(charsetName);
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void initEncoder() {
        try {
            this.encoder = new ExtendedJsonEncoder(LogRecord.getClassSchema(), this.createJsonGen((OutputStream)this.bab));
        }
        catch (IOException ex) {
            this.addError("Cannot ", ex);
        }
    }

    private JsonGenerator createJsonGen(OutputStream os) {
        JsonGenerator agen;
        try {
            agen = Schema.FACTORY.createGenerator((Writer)new OutputStreamWriter(os, this.charset));
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        agen.setPrettyPrinter((PrettyPrinter)JSON_FMT);
        return agen;
    }

    public byte[] headerBytes() {
        try {
            ByteArrayBuilder bb = new ByteArrayBuilder();
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)bb, this.charset);
            JsonGenerator jgen = Json.FACTORY.createGenerator((Writer)osw);
            LogRecord.getClassSchema().toJson((Schema.Names)new AvroNamesRefResolver(SchemaResolvers.getDefault()), jgen);
            jgen.flush();
            osw.append('\n');
            osw.flush();
            return bb.toByteArray();
        }
        catch (IOException | RuntimeException ex) {
            this.addError("Failed to write header for " + LogRecord.class, ex);
            return Arrays.EMPTY_BYTE_ARRAY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encode(ILoggingEvent event) {
        LogRecord record;
        try {
            record = Converters.convert(event);
        }
        catch (RuntimeException ex) {
            Runtime.error((String)("Failed to convert " + event), (Throwable)ex);
            this.addError("Failed to convert " + event, ex);
            return Arrays.EMPTY_BYTE_ARRAY;
        }
        ByteArrayBuilder byteArrayBuilder = this.bab;
        synchronized (byteArrayBuilder) {
            try {
                return this.serializeAvro(record);
            }
            catch (IOException | RuntimeException ex) {
                try {
                    Runtime.error((String)("Failed to serialize " + record), (Throwable)ex);
                    this.addError("Failed to serialize " + record, ex);
                    this.addError("Failed at:" + new String(this.bab.toByteArray(), this.charset) + '\n');
                    this.encoder.flush();
                }
                catch (IOException ex1) {
                    throw new UncheckedIOException(ex1);
                }
                finally {
                    this.initEncoder();
                }
                return Arrays.EMPTY_BYTE_ARRAY;
            }
        }
    }

    public byte[] serializeAvro(LogRecord record) throws IOException {
        this.bab.reset();
        this.writer.write((Object)record, this.encoder);
        this.encoder.flush();
        return this.bab.toByteArray();
    }

    public byte[] footerBytes() {
        return Arrays.EMPTY_BYTE_ARRAY;
    }

    public String toString() {
        return "AvroLogbackEncoder{charset=" + this.charset + '}';
    }
}

