/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.log;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.encoder.EncoderBase;
import java.nio.charset.Charset;
import java.time.format.DateTimeFormatter;
import org.apache.avro.util.Arrays;
import org.spf4j.base.Runtime;
import org.spf4j.log.Converters;
import org.spf4j.log.LogPrinter;

public final class ReadableLogbackEncoder
extends EncoderBase<ILoggingEvent> {
    private Charset charset = Charset.defaultCharset();
    private LogPrinter printer;

    public void setCharset(String charsetName) {
        this.charset = Charset.forName(charsetName);
    }

    public void start() {
        this.printer = new LogPrinter(DateTimeFormatter.ISO_INSTANT, this.charset);
        super.start();
    }

    public byte[] headerBytes() {
        return Arrays.EMPTY_BYTE_ARRAY;
    }

    public byte[] encode(ILoggingEvent event) {
        try {
            return this.printer.printToBytes(Converters.convert2(event));
        }
        catch (RuntimeException ex) {
            Runtime.error((String)("Failed to convert " + event), (Throwable)ex);
            this.addError("Failed to convert " + event, ex);
            return Arrays.EMPTY_BYTE_ARRAY;
        }
    }

    public byte[] footerBytes() {
        return Arrays.EMPTY_BYTE_ARRAY;
    }

    public String toString() {
        return "ReadableLogbackEncoder{charset=" + this.charset + ", printer=" + this.printer + '}';
    }
}

