/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.log;

import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.PackagingDataCalculator;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.spf4j.log.ThrowableProxyUtil;

@SuppressFBWarnings(value={"EI_EXPOSE_REP"})
public final class ThrowableProxy
implements IThrowableProxy {
    private static final ThrowableProxy[] NO_SUPPRESSED = new ThrowableProxy[0];
    private final Throwable throwable;
    private final String className;
    private final String message;
    private final StackTraceElementProxy[] stackTraceElementProxyArray;
    private int commonFrames;
    private ThrowableProxy cause;
    private ThrowableProxy[] suppressed = NO_SUPPRESSED;
    private transient PackagingDataCalculator packagingDataCalculator;
    private boolean calculatedPackageData = false;

    public static ThrowableProxy create(Throwable t) {
        return ThrowableProxy.create(t, null, new HashMap<Throwable, ThrowableProxy>(4));
    }

    private static ThrowableProxy create(Throwable t, ThrowableProxy parent, Map<Throwable, ThrowableProxy> seen) {
        Throwable[] suppressed;
        ThrowableProxy tp = seen.get(t);
        if (tp != null) {
            return tp;
        }
        ThrowableProxy proxy = new ThrowableProxy(t, parent);
        seen.put(t, proxy);
        Throwable cause = t.getCause();
        if (cause != null) {
            proxy.setCause(ThrowableProxy.create(cause, proxy, seen));
        }
        if ((suppressed = t.getSuppressed()).length > 0) {
            ThrowableProxy[] nSuppressed = new ThrowableProxy[suppressed.length];
            for (int i = 0; i < suppressed.length; ++i) {
                nSuppressed[i] = ThrowableProxy.create(suppressed[i], proxy, seen);
            }
            proxy.setSuppressed(nSuppressed);
        }
        return proxy;
    }

    private ThrowableProxy(Throwable throwable, @Nullable ThrowableProxy parent) {
        this.throwable = throwable;
        this.className = throwable.getClass().getName();
        this.message = throwable.getMessage();
        this.stackTraceElementProxyArray = ThrowableProxyUtil.steArrayToStepArray(throwable.getStackTrace());
        if (parent != null) {
            this.commonFrames = ThrowableProxyUtil.findNumberOfCommonFrames(throwable.getStackTrace(), parent.stackTraceElementProxyArray);
        }
    }

    public static IThrowableProxy addSuppressed(final IThrowableProxy to, final IThrowableProxy supressedProxy) {
        return new IThrowableProxy(){

            public String getMessage() {
                return to.getMessage();
            }

            public String getClassName() {
                return to.getClassName();
            }

            public StackTraceElementProxy[] getStackTraceElementProxyArray() {
                return to.getStackTraceElementProxyArray();
            }

            public int getCommonFrames() {
                return to.getCommonFrames();
            }

            public IThrowableProxy getCause() {
                return to.getCause();
            }

            public IThrowableProxy[] getSuppressed() {
                IThrowableProxy[] supp = to.getSuppressed();
                IThrowableProxy[] nsuppressed = Arrays.copyOf(supp, supp.length + 1);
                nsuppressed[supp.length] = supressedProxy;
                return nsuppressed;
            }
        };
    }

    private void setCause(ThrowableProxy tp) {
        this.cause = tp;
    }

    private void setSuppressed(ThrowableProxy[] suppressed) {
        this.suppressed = suppressed;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public String getMessage() {
        return this.message;
    }

    public String getClassName() {
        return this.className;
    }

    public StackTraceElementProxy[] getStackTraceElementProxyArray() {
        return this.stackTraceElementProxyArray;
    }

    public int getCommonFrames() {
        return this.commonFrames;
    }

    public IThrowableProxy getCause() {
        return this.cause;
    }

    public IThrowableProxy[] getSuppressed() {
        return this.suppressed;
    }

    public PackagingDataCalculator getPackagingDataCalculator() {
        if (this.throwable != null && this.packagingDataCalculator == null) {
            this.packagingDataCalculator = new PackagingDataCalculator();
        }
        return this.packagingDataCalculator;
    }

    public void calculatePackagingData() {
        if (this.calculatedPackageData) {
            return;
        }
        PackagingDataCalculator pdc = this.getPackagingDataCalculator();
        if (pdc != null) {
            this.calculatedPackageData = true;
            pdc.calculate((IThrowableProxy)this);
        }
    }

    public String toString() {
        return "ThrowableProxy{throwable=" + this.throwable + ", className=" + this.className + ", message=" + this.message + '}';
    }
}

