/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.ui;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.spf4j.base.EqualsPredicate;
import org.spf4j.base.Pair;
import org.spf4j.ds.Graph;
import org.spf4j.ds.HashMapGraph;
import org.spf4j.ds.Traversals;
import org.spf4j.stackmonitor.InvokedMethod;
import org.spf4j.stackmonitor.SampleNode;
import org.spf4j.ui.FlameStackPanel;
import org.spf4j.ui.Sampled;
import org.spf4j.ui.StackPanelBase;

@SuppressFBWarnings(value={"SE_BAD_FIELD"})
public final class ZStackPanel
extends StackPanelBase {
    private static final long serialVersionUID = 1L;
    private Graph<InvokedMethod, SampleNode.InvocationCount> graph;
    private Graph<InvokedMethod, SampleNode.InvocationCount> completeGraph;
    private Map<InvokedMethod, Rectangle2D> methodLocations;
    private double totalHeight = 0.0;

    public ZStackPanel(SampleNode samples) {
        super(samples);
        this.completeGraph = SampleNode.toGraph((SampleNode)samples);
        this.graph = null;
    }

    @Override
    public int paint(Graphics2D gr, double width, double rowHeight) {
        this.paintGraph(gr, 0, 0, (int)width, rowHeight);
        return (int)this.totalHeight;
    }

    private void paintGraph(final Graphics2D g2, final int x, final int y, final double areaWidth, final double rowHeight) {
        this.graph = this.completeGraph.copy();
        int rootSamples = ((SampleNode.InvocationCount)this.graph.getEdges((Object)InvokedMethod.ROOT).getIncomming().keySet().iterator().next()).getValue();
        final double pps = areaWidth / (double)rootSamples;
        this.methodLocations = new HashMap<InvokedMethod, Rectangle2D>();
        Traversals.TraversalCallback<InvokedMethod, SampleNode.InvocationCount> traversalCallback = new Traversals.TraversalCallback<InvokedMethod, SampleNode.InvocationCount>(){
            private int counter = 0;

            public void handle(InvokedMethod vertex, Map<SampleNode.InvocationCount, InvokedMethod> edges) {
                if (edges.size() == 1) {
                    if (vertex.equals((Object)InvokedMethod.ROOT)) {
                        int nrSamples = edges.keySet().iterator().next().getValue();
                        this.drawMethod(vertex, nrSamples, x, y, areaWidth, rowHeight, new Point[0]);
                    } else {
                        Map.Entry<SampleNode.InvocationCount, InvokedMethod> fromEntry = edges.entrySet().iterator().next();
                        InvokedMethod fromMethod = fromEntry.getValue();
                        Rectangle2D fromMethodLocation = (Rectangle2D)ZStackPanel.this.methodLocations.get(fromMethod);
                        int relativeSamples = 0;
                        for (Map.Entry ens : ZStackPanel.this.graph.getEdges((Object)fromMethod).getOutgoing().entrySet()) {
                            InvokedMethod slm = (InvokedMethod)ens.getValue();
                            if (!ZStackPanel.this.methodLocations.containsKey(slm) || ZStackPanel.this.graph.getEdges((Object)slm).getIncomming().size() != 1 || fromMethod.equals((Object)slm)) continue;
                            relativeSamples += ((SampleNode.InvocationCount)ens.getKey()).getValue();
                        }
                        int nrSamples = fromEntry.getKey().getValue();
                        double width = (double)nrSamples * pps;
                        double newX = fromMethodLocation.getX() + (double)relativeSamples * pps;
                        this.drawMethod(vertex, nrSamples, newX, fromMethodLocation.getY() + rowHeight, width, rowHeight, new Point[0]);
                    }
                } else if (edges.size() > 1) {
                    this.renderMethodLinked(edges, vertex);
                } else {
                    throw new IllegalStateException("Invalid state, there must be a way to get to node " + vertex);
                }
            }

            @SuppressFBWarnings(value={"ISB_TOSTRING_APPENDING"})
            private void drawMethod(InvokedMethod vertex, int nrSamples, double x2, double y2, double width, double height, Point ... fromLinks) {
                Rectangle2D.Double location = new Rectangle2D.Double(x2, y2, width, height);
                ZStackPanel.this.methodLocations.put(vertex, location);
                ZStackPanel.this.insert(x2, y2, width, height, new Sampled<InvokedMethod>(vertex, nrSamples));
                double newHeight = y2 + height;
                if (ZStackPanel.this.totalHeight < newHeight) {
                    ZStackPanel.this.totalHeight = newHeight;
                }
                FlameStackPanel.setElementColor(this.counter++, g2);
                g2.setClip((int)x2, (int)y2, (int)width, (int)height);
                g2.fillRect((int)x2, (int)y2, (int)width, (int)height);
                String val = vertex.getMethod().toString() + '-' + nrSamples;
                g2.setPaint(Color.BLACK);
                g2.drawString(val, (int)x2, (int)(y2 + height - 1.0));
                g2.setClip(null);
                g2.setPaint(StackPanelBase.LINK_COLOR);
                for (Point divLoc : fromLinks) {
                    g2.drawLine((int)divLoc.getX(), (int)divLoc.getY(), (int)(x2 + width / 2.0), (int)y2);
                }
                g2.drawRect((int)x2, (int)y2, (int)width, (int)height);
            }

            private void renderMethodLinked(Map<SampleNode.InvocationCount, InvokedMethod> edges, InvokedMethod vertex) {
                ArrayList<Point> fromPoints = new ArrayList<Point>(edges.size());
                double newYBase = 0.0;
                double newXBase = Double.MAX_VALUE;
                double newWidth = 0.0;
                double maxX = Double.MIN_VALUE;
                int nrSamples = 0;
                for (Map.Entry<SampleNode.InvocationCount, InvokedMethod> fromEntry : edges.entrySet()) {
                    double newY;
                    double mx;
                    Rectangle2D fromRect = (Rectangle2D)ZStackPanel.this.methodLocations.get(fromEntry.getValue());
                    newWidth += (double)fromEntry.getKey().getValue() * pps;
                    nrSamples += fromEntry.getKey().getValue();
                    if (fromRect == null) continue;
                    double fromX = fromRect.getX();
                    if (fromX < newXBase) {
                        newXBase = fromX;
                    }
                    if ((mx = fromRect.getMaxX()) > maxX) {
                        maxX = mx;
                    }
                    if ((newY = fromRect.getMaxY() + rowHeight) > newYBase) {
                        newYBase = newY;
                    }
                    fromPoints.add(new Point((int)fromRect.getCenterX(), (int)fromRect.getMaxY()));
                }
                Pair<List<Sampled<InvokedMethod>>, Double> result = this.findEmptySpace(newXBase, newYBase, newWidth, maxX);
                while (!((List)result.getFirst()).isEmpty()) {
                    result = this.findEmptySpace(newXBase, newYBase += rowHeight, newWidth, maxX);
                }
                this.drawMethod(vertex, nrSamples, (Double)result.getSecond(), newYBase, newWidth, rowHeight, fromPoints.toArray(new Point[fromPoints.size()]));
            }

            @SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS"})
            private Pair<List<Sampled<InvokedMethod>>, Double> findEmptySpace(double newXBase, double newYBase, double newWidth, double maxX) {
                double tryx = newXBase + (maxX - newXBase) / 2.0 - newWidth / 2.0;
                List methods = ZStackPanel.this.search(tryx = this.fitToViewableArea(tryx, newWidth), newYBase, newWidth, 3.4028234663852886E38);
                if (!methods.isEmpty()) {
                    tryx = newXBase;
                    methods = ZStackPanel.this.search(tryx = this.fitToViewableArea(tryx, newWidth), newYBase, newWidth, 3.4028234663852886E38);
                    if (!methods.isEmpty()) {
                        tryx = maxX - newWidth;
                        tryx = this.fitToViewableArea(tryx, newWidth);
                        methods = ZStackPanel.this.search(tryx, newYBase, newWidth, 3.4028234663852886E38);
                    }
                }
                return Pair.of((Object)methods, (Object)tryx);
            }

            private double fitToViewableArea(double ptryx, double newWidth) {
                double tryx = ptryx;
                if (tryx < 0.0) {
                    tryx = 0.0;
                } else if (tryx > areaWidth - newWidth) {
                    tryx = areaWidth - newWidth;
                }
                return tryx;
            }
        };
        Traversals.customTraverse(this.graph, (Object)InvokedMethod.ROOT, (Traversals.TraversalCallback)traversalCallback);
    }

    @Override
    public String getDetail(Point location) {
        List tips = this.search(location.x, location.y, 0, 0);
        if (tips.size() >= 1) {
            Sampled node = (Sampled)tips.get(0);
            InvokedMethod method = (InvokedMethod)node.getObj();
            Map incomming = this.graph.getEdges((Object)method).getIncomming();
            StringBuilder sb = new StringBuilder();
            sb.append(method).append('-').append(node.getNrSamples()).append("\n invoked from: ");
            ZStackPanel.appendEdgeInfo(incomming, sb);
            sb.append("\n invoking: ");
            Map outgoing = this.graph.getEdges((Object)method).getOutgoing();
            ZStackPanel.appendEdgeInfo(outgoing, sb);
            return sb.toString();
        }
        return null;
    }

    @Override
    public void filter() {
        List tips = this.search(this.xx, this.yy, 0, 0);
        if (tips.size() >= 1) {
            InvokedMethod value = ((InvokedMethod)((Sampled)tips.get(0)).getObj()).withId(0);
            this.samples = this.samples.filteredBy((Predicate)new EqualsPredicate((Object)value));
            this.completeGraph = this.samples != null ? SampleNode.toGraph((SampleNode)this.samples) : new HashMapGraph();
            this.repaint();
        }
    }

    private static void appendEdgeInfo(Map<SampleNode.InvocationCount, InvokedMethod> incomming, StringBuilder sb) {
        for (Map.Entry<SampleNode.InvocationCount, InvokedMethod> entry : incomming.entrySet()) {
            int ic = entry.getKey().getValue();
            InvokedMethod method = entry.getValue();
            sb.append(method).append('-').append(ic).append("; ");
        }
    }
}

