/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.impl.chart;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import org.jfree.chart.axis.NumberTickUnit;
import org.joda.time.format.DateTimeFormatter;

@SuppressFBWarnings(value={"NFF_NON_FUNCTIONAL_FIELD", "SE_TRANSIENT_FIELD_NOT_RESTORED"})
class TimestampTickUnitImpl
extends NumberTickUnit {
    private static final long serialVersionUID = 0L;
    private final long[] timestamps;
    private final long stepMillis;
    private final transient DateTimeFormatter formatter;

    TimestampTickUnitImpl(double size, long[] timestamps, long stepMillis, DateTimeFormatter formatter) {
        super(size);
        this.timestamps = timestamps;
        this.formatter = formatter;
        this.stepMillis = stepMillis;
    }

    public String valueToString(double value) {
        int ival = (int)Math.round(value);
        long val = ival >= this.timestamps.length ? this.timestamps[this.timestamps.length - 1] + this.stepMillis * (long)(ival - this.timestamps.length + 1) : (ival < 0 ? this.timestamps[0] + (long)ival * this.stepMillis : this.timestamps[ival]);
        return this.formatter.print(val);
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Arrays.hashCode(this.timestamps);
        hash = 89 * hash + (int)(this.stepMillis ^ this.stepMillis >>> 32);
        return 89 * hash + (this.formatter != null ? this.formatter.hashCode() : 0);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        TimestampTickUnitImpl other = (TimestampTickUnitImpl)((Object)obj);
        if (!Arrays.equals(this.timestamps, other.timestamps)) {
            return false;
        }
        if (this.stepMillis != other.stepMillis) {
            return false;
        }
        return this.formatter == other.formatter || this.formatter != null && this.formatter.equals(other.formatter);
    }
}

