/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.ui;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.layout.GroupLayout;
import org.spf4j.base.AbstractRunnable;
import org.spf4j.ui.StackDumpJInternalFrame;
import org.spf4j.ui.TSDB2ViewJInternalFrame;
import org.spf4j.ui.TSDBViewJInternalFrame;

@SuppressFBWarnings(value={"FCBL_FIELD_COULD_BE_LOCAL", "UP_UNUSED_PARAMETER"})
public class Explorer
extends JFrame {
    private static final long serialVersionUID = 1L;
    private File folder = null;
    private JMenuItem aboutMenuItem;
    private JMenuItem contentMenuItem;
    private JMenuItem copyMenuItem;
    private JMenuItem cutMenuItem;
    private JMenuItem deleteMenuItem;
    private JDesktopPane desktopPane;
    private JMenu editMenu;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JMenuBar menuBar;
    private JMenuItem openMenuItem;
    private JMenuItem pasteMenuItem;

    public Explorer(String ... openFiles) throws IOException {
        this.initComponents();
        for (String file : openFiles) {
            this.openFile(new File(file));
        }
    }

    private void initComponents() {
        this.desktopPane = new JDesktopPane();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.openMenuItem = new JMenuItem();
        this.exitMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.cutMenuItem = new JMenuItem();
        this.copyMenuItem = new JMenuItem();
        this.pasteMenuItem = new JMenuItem();
        this.deleteMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.contentMenuItem = new JMenuItem();
        this.aboutMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.desktopPane.setAutoscrolls(true);
        this.desktopPane.setDoubleBuffered(true);
        this.desktopPane.setPreferredSize(new Dimension(800, 600));
        this.fileMenu.setMnemonic('f');
        this.fileMenu.setText("File");
        this.openMenuItem.setMnemonic('o');
        this.openMenuItem.setText("Open");
        this.openMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Explorer.this.openMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openMenuItem);
        this.exitMenuItem.setMnemonic('x');
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Explorer.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.editMenu.setMnemonic('e');
        this.editMenu.setText("Edit");
        this.cutMenuItem.setMnemonic('t');
        this.cutMenuItem.setText("Cut");
        this.editMenu.add(this.cutMenuItem);
        this.copyMenuItem.setMnemonic('y');
        this.copyMenuItem.setText("Copy");
        this.editMenu.add(this.copyMenuItem);
        this.pasteMenuItem.setMnemonic('p');
        this.pasteMenuItem.setText("Paste");
        this.editMenu.add(this.pasteMenuItem);
        this.deleteMenuItem.setMnemonic('d');
        this.deleteMenuItem.setText("Delete");
        this.editMenu.add(this.deleteMenuItem);
        this.menuBar.add(this.editMenu);
        this.helpMenu.setMnemonic('h');
        this.helpMenu.setText("Help");
        this.contentMenuItem.setMnemonic('c');
        this.contentMenuItem.setText("Contents");
        this.helpMenu.add(this.contentMenuItem);
        this.aboutMenuItem.setMnemonic('a');
        this.aboutMenuItem.setText("About");
        this.helpMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.desktopPane, -1, 1149, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.desktopPane, -1, 668, Short.MAX_VALUE));
        this.pack();
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void openMenuItemActionPerformed(ActionEvent evt) {
        int returnVal;
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogType(0);
        chooser.setFileFilter(new Spf4jFileFilter());
        if (this.folder != null) {
            chooser.setCurrentDirectory(this.folder);
        }
        if ((returnVal = chooser.showOpenDialog(this)) == 0) {
            File file = chooser.getSelectedFile();
            this.folder = file.getParentFile();
            try {
                this.openFile(file);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private void openFile(File file) throws IOException {
        JInternalFrame frame;
        String fileName = file.getName();
        String absolutePath = file.getAbsolutePath();
        if (fileName.endsWith("tsdb")) {
            frame = new TSDBViewJInternalFrame(absolutePath);
        } else if (fileName.endsWith("tsdb2")) {
            frame = new TSDB2ViewJInternalFrame(absolutePath);
        } else if (fileName.endsWith("ssdump") || fileName.endsWith("ssdump2")) {
            frame = new StackDumpJInternalFrame(absolutePath, true);
            frame.setVisible(true);
            this.desktopPane.add((Component)frame, JLayeredPane.DEFAULT_LAYER);
            frame = new StackDumpJInternalFrame(absolutePath, false);
        } else {
            throw new RuntimeException("Unsupported file format " + fileName);
        }
        frame.setVisible(true);
        this.desktopPane.add((Component)frame, JLayeredPane.DEFAULT_LAYER);
    }

    public static void main(final String[] args) {
        System.setProperty("spf4j.tsdb2.lenientRead", "true");
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(Explorer.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(Explorer.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(Explorer.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(Explorer.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater((Runnable)new AbstractRunnable(false){

            public void doRun() throws IOException {
                new Explorer(args).setVisible(true);
            }
        });
    }

    private static class Spf4jFileFilter
    extends FileFilter {
        private Spf4jFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            if (f.isFile()) {
                String name = f.getName();
                return name.endsWith("tsdb") || name.endsWith("tsdb2") || name.endsWith("ssdump") || name.endsWith("ssdump2");
            }
            return false;
        }

        @Override
        public String getDescription() {
            return "spf4j dumps";
        }
    }
}

