/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.ui;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.ToolTipManager;
import org.spf4j.ds.RTree;
import org.spf4j.stackmonitor.SampleNode;
import org.spf4j.ui.Sampled;

public abstract class StackPanelBase
extends JPanel
implements ActionListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    protected SampleNode samples;
    private RTree<Sampled<?>> tooltipDetail = new RTree();
    protected int xx;
    protected int yy;
    private final JPopupMenu menu;
    public static final Color LINK_COLOR = new Color(128, 128, 128, 128);

    public StackPanelBase(SampleNode samples) {
        this.samples = samples;
        this.setPreferredSize(new Dimension(400, 20 * samples.height() + 10));
        ToolTipManager sharedInstance = ToolTipManager.sharedInstance();
        sharedInstance.registerComponent(this);
        sharedInstance.setDismissDelay(30000);
        this.menu = StackPanelBase.buildPopupMenu(this);
        this.addMouseListener(this);
    }

    public final List search(int x, int y, int w, int h) {
        return this.tooltipDetail.search(new float[]{x, y}, new float[]{w, h});
    }

    public final List search(double x, double y, double w, double h) {
        return this.tooltipDetail.search(new float[]{(float)x, (float)y}, new float[]{(float)w, (float)h});
    }

    public final void insert(int x, int y, int w, int h, Sampled sampled) {
        this.tooltipDetail.insert(new float[]{x, y}, new float[]{w, h}, (Object)sampled);
    }

    public final void insert(double x, double y, double w, double h, Sampled sampled) {
        this.tooltipDetail.insert(new float[]{(float)x, (float)y}, new float[]{(float)w, (float)h}, (Object)sampled);
    }

    @SuppressFBWarnings
    private static JPopupMenu buildPopupMenu(ActionListener listener) {
        JPopupMenu result = new JPopupMenu("Actions");
        JMenuItem filter = new JMenuItem("Filter");
        filter.setActionCommand("FILTER");
        filter.addActionListener(listener);
        result.add(filter);
        JMenuItem copy = new JMenuItem("Copy");
        copy.setActionCommand("COPY");
        copy.addActionListener(listener);
        result.add(copy);
        return result;
    }

    @Override
    public final String getToolTipText(MouseEvent event) {
        Point location = event.getPoint();
        return this.getDetail(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void paintComponent(Graphics g) {
        super.paintComponent(g);
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        Rectangle2D.Double available = new Rectangle2D.Double(insets.left, insets.top, size.getWidth() - (double)insets.left - (double)insets.right, size.getHeight() - (double)insets.top - (double)insets.bottom);
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            double rowHeight = g2.getFont().getStringBounds("ROOT", g2.getFontRenderContext()).getHeight();
            GraphicsConfiguration gc = g2.getDeviceConfiguration();
            BufferedImage img = gc.createCompatibleImage((int)((RectangularShape)available).getWidth(), (int)((RectangularShape)available).getHeight(), 3);
            double width = ((RectangularShape)available).getWidth();
            this.tooltipDetail.clear();
            Graphics2D gr = img.createGraphics();
            gr.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            int height = this.paint(gr, width, rowHeight);
            g2.drawImage((Image)img, insets.left, insets.top, this);
            Dimension dimension = new Dimension((int)size.getWidth(), height + 10);
            this.setPreferredSize(dimension);
            this.setSize(dimension);
        }
        finally {
            g2.dispose();
        }
    }

    public abstract int paint(Graphics2D var1, double var2, double var4);

    @Override
    public final void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("FILTER".equals(actionCommand)) {
            this.filter();
        } else if ("COPY".equals(actionCommand)) {
            final String detail = this.getDetail(new Point(this.xx, this.yy));
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new Transferable(){

                @Override
                public DataFlavor[] getTransferDataFlavors() {
                    return new DataFlavor[]{DataFlavor.stringFlavor};
                }

                @Override
                public boolean isDataFlavorSupported(DataFlavor flavor) {
                    return flavor.equals(DataFlavor.stringFlavor);
                }

                @Override
                public Object getTransferData(DataFlavor flavor) {
                    return detail;
                }
            }, new ClipboardOwner(){

                @Override
                public void lostOwnership(Clipboard clipboard, Transferable contents) {
                }
            });
        }
    }

    @Override
    public final void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.xx = e.getX();
            this.yy = e.getY();
            this.menu.show(this, e.getX(), e.getY());
        }
    }

    @Override
    public final void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.xx = e.getX();
            this.yy = e.getY();
            this.menu.show(this, e.getX(), e.getY());
        }
    }

    @Override
    @SuppressFBWarnings
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    @SuppressFBWarnings
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    @SuppressFBWarnings
    public void mouseExited(MouseEvent e) {
    }

    public static void setElementColor(int depth, Graphics2D g2) {
        if (depth % 2 == 0) {
            g2.setPaint(Color.YELLOW);
            g2.setBackground(Color.YELLOW);
        } else {
            g2.setPaint(Color.ORANGE);
            g2.setBackground(Color.ORANGE);
        }
    }

    public abstract String getDetail(Point var1);

    public abstract void filter();
}

