/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.impl.chart;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardXYSeriesLabelGenerator;
import org.jfree.chart.labels.XYSeriesLabelGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.PaintScale;
import org.jfree.chart.renderer.xy.XYBlockRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.PaintScaleLegend;
import org.jfree.chart.title.Title;
import org.jfree.data.time.FixedMillisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.spf4j.base.Arrays;
import org.spf4j.base.Pair;
import org.spf4j.perf.impl.chart.InverseGrayScale;
import org.spf4j.perf.impl.chart.QuantizedXYZDatasetImpl;

public final class Charts {
    private Charts() {
    }

    @SuppressFBWarnings(value={"CE_CLASS_ENVY"})
    public static JFreeChart createHeatJFreeChart(String[] dsNames, double[][] values, long startTimeMillis, long stepMillis, String uom, String chartName) {
        QuantizedXYZDatasetImpl dataSet = new QuantizedXYZDatasetImpl(dsNames, values, startTimeMillis, stepMillis);
        NumberAxis xAxis = new NumberAxis("Time");
        xAxis.setStandardTickUnits((TickUnitSource)dataSet.createXTickUnits());
        xAxis.setLowerMargin(0.0);
        xAxis.setUpperMargin(0.0);
        xAxis.setVerticalTickLabels(true);
        NumberAxis yAxis = new NumberAxis(uom);
        yAxis.setStandardTickUnits((TickUnitSource)dataSet.createYTickUnits());
        yAxis.setLowerMargin(0.0);
        yAxis.setUpperMargin(0.0);
        XYBlockRenderer renderer = new XYBlockRenderer();
        InverseGrayScale scale = dataSet.getMinValue() >= dataSet.getMaxValue() ? (dataSet.getMinValue() == Double.POSITIVE_INFINITY ? new InverseGrayScale(0.0, 1.0) : new InverseGrayScale(dataSet.getMinValue(), dataSet.getMaxValue() + 1.0)) : new InverseGrayScale(dataSet.getMinValue(), dataSet.getMaxValue());
        renderer.setPaintScale((PaintScale)scale);
        renderer.setBlockWidth(1.0);
        renderer.setBlockHeight(1.0);
        XYPlot plot = new XYPlot((XYDataset)dataSet, (ValueAxis)xAxis, (ValueAxis)yAxis, (XYItemRenderer)renderer);
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setDomainGridlinesVisible(false);
        plot.setRangeGridlinesVisible(false);
        plot.setRangeMinorGridlinesVisible(false);
        JFreeChart chart = new JFreeChart(chartName, (Plot)plot);
        PaintScaleLegend legend = new PaintScaleLegend((PaintScale)scale, (ValueAxis)new NumberAxis("Count"));
        legend.setMargin(0.0, 5.0, 0.0, 5.0);
        chart.addSubtitle((Title)legend);
        chart.removeLegend();
        chart.setBackgroundPaint((Paint)Color.white);
        return chart;
    }

    private static JFreeChart createJFreeChart(String chartName, String uom, XYDataset timeseriescollection) {
        JFreeChart jfreechart = ChartFactory.createTimeSeriesChart((String)chartName, (String)"Time", (String)uom, (XYDataset)timeseriescollection, (boolean)true, (boolean)true, (boolean)false);
        XYPlot xyplot = (XYPlot)jfreechart.getPlot();
        DateAxis dateaxis = (DateAxis)xyplot.getDomainAxis();
        dateaxis.setVerticalTickLabels(true);
        XYLineAndShapeRenderer xylineandshaperenderer = (XYLineAndShapeRenderer)xyplot.getRenderer();
        xylineandshaperenderer.setBaseShapesVisible(true);
        xylineandshaperenderer.setUseFillPaint(true);
        xylineandshaperenderer.setLegendItemToolTipGenerator((XYSeriesLabelGenerator)new StandardXYSeriesLabelGenerator("Tooltip {0}"));
        return jfreechart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage createMinMaxAvgCountImg(String chartName, long[] timestamps, double[] min, double[] max, double[] total, double[] count, String uom, int width, int height) {
        BufferedImage bi = Charts.createTimeSeriesJFreeChart(chartName, timestamps, new String[]{"min", "max", "avg"}, uom, (double[][])new double[][]{min, max, Arrays.divide((double[])total, (double[])count)}).createBufferedImage(width, height - height / 3);
        BufferedImage bi2 = Charts.createTimeSeriesJFreeChart(null, timestamps, new String[]{"count"}, "count", (double[][])new double[][]{count}).createBufferedImage(width, height / 3);
        BufferedImage combined = new BufferedImage(width, height, 1);
        Graphics graphics = combined.getGraphics();
        try {
            graphics.drawImage(bi, 0, 0, null);
            graphics.drawImage(bi2, 0, height - height / 3, null);
        }
        finally {
            graphics.dispose();
        }
        return combined;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage generateCountTotalChart(String groupName, long[][] timestamps, String[] measurementNames, String uom1, double[][] measurements, int width, int height, String[] measurementNames2, String uom2, double[][] measurements2) {
        BufferedImage count = Charts.createTimeSeriesJFreeChart("Measurements for " + groupName + " generated by spf4j", timestamps, measurementNames, uom1, measurements).createBufferedImage(width, height / 2);
        BufferedImage total = Charts.createTimeSeriesJFreeChart(null, timestamps, measurementNames2, uom2, measurements2).createBufferedImage(width, height / 2);
        BufferedImage combined = new BufferedImage(width, height, 1);
        Graphics graphics = combined.getGraphics();
        try {
            graphics.drawImage(count, 0, 0, null);
            graphics.drawImage(total, 0, height / 2, null);
        }
        finally {
            graphics.dispose();
        }
        return combined;
    }

    private static TimeSeriesCollection createTimeSeriesCollection(String[] measurementNames, long[] timestamps, double[][] measurements) {
        TimeSeriesCollection timeseriescollection = new TimeSeriesCollection();
        for (int i = 0; i < measurementNames.length; ++i) {
            TimeSeries tseries = new TimeSeries((Comparable)((Object)measurementNames[i]));
            for (int j = 0; j < timestamps.length; ++j) {
                FixedMillisecond ts = new FixedMillisecond(timestamps[j]);
                tseries.add((RegularTimePeriod)ts, measurements[i][j]);
            }
            timeseriescollection.addSeries(tseries);
        }
        return timeseriescollection;
    }

    public static JFreeChart createTimeSeriesJFreeChart(String chartName, long[] timestamps, String[] measurementNames, String uom, double[][] measurements) {
        TimeSeriesCollection timeseriescollection = Charts.createTimeSeriesCollection(measurementNames, timestamps, measurements);
        return Charts.createJFreeChart(chartName, uom, (XYDataset)timeseriescollection);
    }

    private static TimeSeriesCollection createTimeSeriesCollection(String[] measurementNames, long[][] timestamps, double[][] measurements) {
        TimeSeriesCollection timeseriescollection = new TimeSeriesCollection();
        for (int i = 0; i < measurementNames.length; ++i) {
            TimeSeries tseries = new TimeSeries((Comparable)((Object)measurementNames[i]));
            for (int j = 0; j < timestamps[i].length; ++j) {
                FixedMillisecond ts = new FixedMillisecond(timestamps[i][j]);
                tseries.add((RegularTimePeriod)ts, measurements[i][j]);
            }
            timeseriescollection.addSeries(tseries);
        }
        return timeseriescollection;
    }

    public static JFreeChart createTimeSeriesJFreeChart(String chartName, long[][] timestamps, String[] measurementNames, String uom, double[][] measurements) {
        TimeSeriesCollection timeseriescollection = Charts.createTimeSeriesCollection(measurementNames, timestamps, measurements);
        return Charts.createJFreeChart(chartName, uom, (XYDataset)timeseriescollection);
    }

    public static Pair<long[], double[][]> fillGaps(long[] timestamps, long[][] data, int sampleTime, int nrColumns) {
        int i;
        long startTime = timestamps[0];
        int nrSamples = (int)((timestamps[timestamps.length - 1] - startTime) / (long)sampleTime) + 1;
        long[] lts = new long[nrSamples];
        double[][] dr = new double[nrSamples][];
        long nextTime = startTime;
        int j = 0;
        int maxDeviation = sampleTime / 2;
        double[] nodata = new double[nrColumns];
        for (i = 0; i < nrColumns; ++i) {
            nodata[i] = Double.NaN;
        }
        for (i = 0; i < nrSamples; ++i) {
            lts[i] = nextTime;
            if (Math.abs(timestamps[j] - nextTime) < (long)maxDeviation) {
                dr[i] = Arrays.toDoubleArray((long[])data[j]);
                ++j;
            } else {
                dr[i] = nodata;
            }
            nextTime += (long)sampleTime;
        }
        return Pair.of((Object)lts, (Object)dr);
    }
}

