/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.impl.chart;

import java.awt.Color;
import java.awt.Paint;
import java.io.Serializable;
import org.jfree.chart.renderer.PaintScale;
import org.jfree.util.PublicCloneable;
import org.spf4j.base.CloneFailedException;

public final class InverseGrayScale
implements PaintScale,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final double lowerBound;
    private final double upperBound;
    private final int alpha;

    public InverseGrayScale() {
        this(0.0, 1.0);
    }

    public InverseGrayScale(double lowerBound, double upperBound) {
        this(lowerBound, upperBound, 255);
    }

    public InverseGrayScale(double lowerBound, double upperBound, int alpha) {
        if (lowerBound >= upperBound) {
            throw new IllegalArgumentException("Requires " + lowerBound + " < " + upperBound + '.');
        }
        if (alpha < 0 || alpha > 255) {
            throw new IllegalArgumentException("Requires alpha in the range 0 to 255. and not " + alpha);
        }
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.alpha = alpha;
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public Paint getPaint(double value) {
        double v = Math.max(value, this.lowerBound);
        v = Math.min(v, this.upperBound);
        int g = value >= 1.0 ? 240 - (int)((v - this.lowerBound) / (this.upperBound - this.lowerBound) * 240.0) : 255 - (int)((v - this.lowerBound) / (this.upperBound - this.lowerBound) * 15.0);
        return new Color(g, g, g, this.alpha);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InverseGrayScale other = (InverseGrayScale)obj;
        if (Double.doubleToLongBits(this.lowerBound) != Double.doubleToLongBits(other.lowerBound)) {
            return false;
        }
        if (Double.doubleToLongBits(this.upperBound) != Double.doubleToLongBits(other.upperBound)) {
            return false;
        }
        return this.alpha == other.alpha;
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + (int)(Double.doubleToLongBits(this.lowerBound) ^ Double.doubleToLongBits(this.lowerBound) >>> 32);
        hash = 97 * hash + (int)(Double.doubleToLongBits(this.upperBound) ^ Double.doubleToLongBits(this.upperBound) >>> 32);
        return 97 * hash + this.alpha;
    }

    public InverseGrayScale clone() {
        try {
            return (InverseGrayScale)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new CloneFailedException("Failed cloning " + this, (Throwable)ex);
        }
    }

    public String toString() {
        return "InverseGrayScale{lowerBound=" + this.lowerBound + ", upperBound=" + this.upperBound + ", alpha=" + this.alpha + '}';
    }
}

