/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.impl.chart;

import java.util.List;
import org.jfree.chart.axis.NumberTickUnit;
import org.spf4j.base.ComparablePair;
import org.spf4j.perf.impl.Quanta;

public final class QuantizedNumberTickUnit
extends NumberTickUnit {
    private static final long serialVersionUID = 1L;
    private final List<ComparablePair<Quanta, Integer>> quantas;

    public QuantizedNumberTickUnit(double size, List<ComparablePair<Quanta, Integer>> quantas) {
        super(size);
        this.quantas = quantas;
    }

    public String valueToString(double value) {
        int idx = (int)Math.round(value);
        if (idx < 0) {
            return "NI";
        }
        if (idx >= this.quantas.size()) {
            return "PI";
        }
        long val = ((Quanta)this.quantas.get(idx).getFirst()).getIntervalStart();
        if (val == Long.MIN_VALUE) {
            return "NI";
        }
        return Long.toString(val);
    }

    public int hashCode() {
        int hash = 3;
        return 37 * hash + (this.quantas != null ? this.quantas.hashCode() : 0);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        QuantizedNumberTickUnit other = (QuantizedNumberTickUnit)((Object)obj);
        return this.quantas == other.quantas || this.quantas != null && this.quantas.equals(other.quantas);
    }
}

