/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.stackmonitor;

import com.google.common.annotations.Beta;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import gnu.trove.map.TMap;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.spf4j.base.Method;
import org.spf4j.base.Pair;
import org.spf4j.stackmonitor.SampleNode;

@Beta
public final class SampleGraph {
    private final SetMultimap<SampleKey, Sample> vertexMap;
    private final Map<SampleKey, AggSample> aggregates;
    private final MutableGraph<Sample> sampleTree;
    private final MutableGraph<AggSample> aggGraph;
    private final Sample rootVertex;

    public SampleGraph(Method m, SampleNode node) {
        int nrNodes = node.getNrNodes();
        this.vertexMap = MultimapBuilder.hashKeys((int)nrNodes).hashSetValues(1).build();
        this.aggregates = new THashMap(nrNodes);
        this.sampleTree = GraphBuilder.directed().nodeOrder(ElementOrder.unordered()).allowsSelfLoops(false).expectedNodeCount(nrNodes).build();
        this.aggGraph = GraphBuilder.directed().nodeOrder(ElementOrder.unordered()).allowsSelfLoops(false).expectedNodeCount(nrNodes).build();
        this.rootVertex = this.tree2Graph(m, node);
    }

    private int computeMethodIdx(Sample from, Method m) {
        if (from.key.method.equals((Object)m)) {
            return from.key.idxInHierarchy + 1;
        }
        Set predecessors = this.sampleTree.predecessors((Object)from);
        int size = predecessors.size();
        if (size == 1) {
            return this.computeMethodIdx((Sample)predecessors.iterator().next(), m);
        }
        if (size > 1) {
            throw new IllegalStateException("Cannot have multiple predecesors for " + from + ", pred = " + predecessors);
        }
        return 0;
    }

    private Sample tree2Graph(Method m, SampleNode node) {
        TraversalData t;
        Sample parentVertex = new Sample(new SampleKey(m, 0), node.getSampleCount(), 0, node);
        if (!this.sampleTree.addNode((Object)parentVertex)) {
            throw new IllegalStateException();
        }
        if (!this.vertexMap.put((Object)parentVertex.key, (Object)parentVertex)) {
            throw new IllegalStateException();
        }
        AggSample aggSampleVertex = new AggSample(parentVertex);
        this.aggGraph.addNode((Object)aggSampleVertex);
        this.aggregates.put(parentVertex.key, aggSampleVertex);
        ArrayDeque dq = new ArrayDeque();
        TMap subNodes = node.getSubNodes();
        if (subNodes != null) {
            subNodes.forEachEntry((k, v) -> {
                dq.add(new TraversalData(parentVertex, (Method)k, (SampleNode)v));
                return true;
            });
        }
        while ((t = (TraversalData)dq.pollFirst()) != null) {
            SampleKey vtxk = new SampleKey(t.method, this.computeMethodIdx(t.parent, t.method));
            Sample vtx = new Sample(vtxk, t.node.getSampleCount(), ((TraversalData)t).parent.level + 1, t.node);
            AggSample aggParent = this.aggregates.get(t.parent.key);
            AggSample current = this.aggregates.get(vtxk);
            if (current == null) {
                current = new AggSample(vtx);
                this.aggGraph.addNode((Object)current);
                this.aggregates.put(vtxk, current);
            } else {
                current.add(vtx);
            }
            if (!this.sampleTree.addNode((Object)vtx)) {
                throw new IllegalStateException();
            }
            if (!this.vertexMap.put((Object)vtx.key, (Object)vtx)) {
                throw new IllegalStateException();
            }
            this.aggGraph.putEdge((Object)aggParent, (Object)current);
            if (!this.sampleTree.putEdge((Object)t.parent, (Object)vtx)) {
                throw new IllegalStateException();
            }
            TMap subNodes2 = t.node.getSubNodes();
            Sample vvv = vtx;
            if (subNodes2 == null) continue;
            subNodes2.forEachEntry((k, v) -> {
                dq.add(new TraversalData(vvv, (Method)k, (SampleNode)v));
                return true;
            });
        }
        this.updateLevels(aggSampleVertex);
        return parentVertex;
    }

    private void updateLevels(AggSample sample) {
        Pair curr;
        THashSet seen = new THashSet();
        ArrayDeque trq = new ArrayDeque();
        this.aggGraph.successors((Object)sample).forEach(n -> trq.add(Pair.of((Object)n, (Object)(sample.level + 1))));
        while ((curr = (Pair)trq.pollFirst()) != null) {
            AggSample first = (AggSample)curr.getFirst();
            if (!seen.add(first)) continue;
            Integer second = (Integer)curr.getSecond();
            first.addLevel(second);
            Set successors = this.aggGraph.successors((Object)first);
            successors.forEach(n -> trq.add(Pair.of((Object)n, (Object)(second + 1))));
        }
    }

    public Sample getRootVertex() {
        return this.rootVertex;
    }

    public AggSample getAggRootVertex() {
        return this.aggregates.get(this.rootVertex.key);
    }

    public int getAggNodesNr() {
        return this.aggregates.size();
    }

    public boolean haveCommonChild(AggSample a, AggSample b) {
        AggSample curr;
        if (a.getKey().equals(b.getKey())) {
            return true;
        }
        THashSet traversed = new THashSet();
        ArrayDeque<AggSample> trq = new ArrayDeque<AggSample>();
        trq.add(a);
        trq.add(b);
        while ((curr = (AggSample)trq.pollFirst()) != null) {
            if (!traversed.add(curr.getKey())) {
                return true;
            }
            this.aggGraph.successors((Object)curr).forEach(n -> trq.add((AggSample)n));
        }
        return false;
    }

    public boolean isParentDescendant(AggSample a, AggSample b) {
        AggSample curr;
        ArrayDeque<AggSample> trq = new ArrayDeque<AggSample>();
        trq.add(a);
        while ((curr = (AggSample)trq.pollFirst()) != null) {
            if (curr.equals(b)) {
                return true;
            }
            this.aggGraph.successors((Object)curr).forEach(n -> trq.add((AggSample)n));
        }
        return false;
    }

    public Set<AggSample> getParents(AggSample node) {
        return this.aggGraph.predecessors((Object)node);
    }

    public Set<AggSample> getChildren(AggSample node) {
        return this.aggGraph.successors((Object)node);
    }

    public AggSample getAggNode(SampleKey key) {
        return this.aggregates.get(key);
    }

    public Set<Sample> getSamples(SampleKey key) {
        return this.vertexMap.get((Object)key);
    }

    public String toString() {
        return "SampleGraph{vertexMap=" + this.vertexMap + ", aggregates=" + this.aggregates + ", sampleTree=" + this.sampleTree + ", aggGraph=" + this.aggGraph + ", rootVertex=" + this.rootVertex + '}';
    }

    private static final class TraversalData {
        private final Sample parent;
        private final Method method;
        private final SampleNode node;

        TraversalData(Sample parent, Method method, SampleNode node) {
            this.parent = parent;
            this.method = method;
            this.node = node;
        }
    }

    public static final class AggSample
    extends Sample {
        public AggSample(Sample sample) {
            super(sample.key, sample.nrSamples, sample.level, sample.node);
        }

        public void add(Sample sample) {
            this.nrSamples += sample.nrSamples;
        }

        public void addLevel(int plevel) {
            this.level = Math.max(plevel, this.level);
        }

        @Override
        public String toString() {
            return "AggSample{key=" + this.getKey() + ", nrSamples=" + this.nrSamples + ", level=" + this.level + '}';
        }
    }

    public static class Sample {
        private final SampleKey key;
        protected int nrSamples;
        protected int level;
        private final SampleNode node;

        public Sample(SampleKey key, int nrSamples, int level, SampleNode node) {
            this.key = key;
            this.nrSamples = nrSamples;
            this.level = level;
            this.node = node;
        }

        public final SampleKey getKey() {
            return this.key;
        }

        public final int getNrSamples() {
            return this.nrSamples;
        }

        public final int getLevel() {
            return this.level;
        }

        public final SampleNode getNode() {
            return this.node;
        }

        public String toString() {
            return "Sample{key=" + this.key + ", nrSamples=" + this.nrSamples + ", level=" + this.level + '}';
        }
    }

    public static final class SampleKey {
        private final Method method;
        private int idxInHierarchy;

        public SampleKey(Method method, int idxInHierarchy) {
            this.method = method;
            this.idxInHierarchy = idxInHierarchy;
        }

        public int hashCode() {
            int hash = 59 + Objects.hashCode(this.method);
            return 59 * hash + this.idxInHierarchy;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SampleKey other = (SampleKey)obj;
            if (this.idxInHierarchy != other.idxInHierarchy) {
                return false;
            }
            return Objects.equals(this.method, other.method);
        }

        public Method getMethod() {
            return this.method;
        }

        public String toString() {
            return "SampleKey{method=" + this.method + ", idxInHierarchy=" + this.idxInHierarchy + '}';
        }
    }
}

