/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.ui;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.CodedInputStream;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.DefaultEditorKit;
import org.jdesktop.layout.GroupLayout;
import org.spf4j.base.AbstractRunnable;
import org.spf4j.base.Runtime;
import org.spf4j.base.SysExits;
import org.spf4j.base.Throwables;
import org.spf4j.ssdump2.Converter;
import org.spf4j.stackmonitor.SampleNode;
import org.spf4j.stackmonitor.Sampler;
import org.spf4j.stackmonitor.proto.gen.ProtoSampleNodes;
import org.spf4j.ui.StackDumpJInternalFrame;
import org.spf4j.ui.TSDB2ViewJInternalFrame;
import org.spf4j.ui.TSDBViewJInternalFrame;
import org.spf4j.ui.TextEntryPanel;

@SuppressFBWarnings(value={"FCBL_FIELD_COULD_BE_LOCAL", "UP_UNUSED_PARAMETER", "S508C_NON_TRANSLATABLE_STRING", "SE_BAD_FIELD"})
public class Explorer
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final Lock ERR_LOCK = new ReentrantLock();
    private File folder;
    private Sampler sampler;
    private JMenuItem aboutMenuItem;
    private JMenuItem contentMenuItem;
    private JMenuItem copyMenuItem;
    private JMenuItem cutMenuItem;
    private JMenuItem deleteMenuItem;
    private JDesktopPane desktopPane;
    private JMenu editMenu;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JMenuItem fromTextMenuItem;
    private JMenu helpMenu;
    private JMenu jMenu1;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JMenuBar menuBar;
    private JMenuItem openMenuItem;
    private JMenuItem pasteMenuItem;

    private void initComponents() {
        this.desktopPane = new JDesktopPane();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.openMenuItem = new JMenuItem();
        this.fromTextMenuItem = new JMenuItem();
        this.exitMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.cutMenuItem = new JMenuItem();
        this.copyMenuItem = new JMenuItem();
        this.pasteMenuItem = new JMenuItem();
        this.deleteMenuItem = new JMenuItem();
        this.jMenu1 = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItem2 = new JMenuItem();
        this.helpMenu = new JMenu();
        this.contentMenuItem = new JMenuItem();
        this.aboutMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.desktopPane.setAutoscrolls(true);
        this.desktopPane.setDoubleBuffered(true);
        this.desktopPane.setPreferredSize(new Dimension(800, 600));
        this.desktopPane.setLayout(null);
        this.fileMenu.setMnemonic('f');
        this.fileMenu.setText("File");
        this.openMenuItem.setMnemonic('o');
        this.openMenuItem.setText("Open");
        this.openMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Explorer.this.openMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openMenuItem);
        this.fromTextMenuItem.setMnemonic('o');
        this.fromTextMenuItem.setText("FromText");
        this.fromTextMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Explorer.this.fromTextMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.fromTextMenuItem);
        this.exitMenuItem.setMnemonic('x');
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Explorer.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.editMenu.setMnemonic('e');
        this.editMenu.setText("Edit");
        this.cutMenuItem.setMnemonic('t');
        this.cutMenuItem.setText("Cut");
        this.editMenu.add(this.cutMenuItem);
        this.copyMenuItem.setMnemonic('y');
        this.copyMenuItem.setText("Copy");
        this.editMenu.add(this.copyMenuItem);
        this.pasteMenuItem.setMnemonic('p');
        this.pasteMenuItem.setText("Paste");
        this.editMenu.add(this.pasteMenuItem);
        this.deleteMenuItem.setMnemonic('d');
        this.deleteMenuItem.setText("Delete");
        this.editMenu.add(this.deleteMenuItem);
        this.menuBar.add(this.editMenu);
        this.jMenu1.setText("SelfProfile");
        this.jMenuItem1.setText("Start");
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Explorer.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem1);
        this.jMenuItem2.setText("Stop & Display");
        this.jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Explorer.this.jMenuItem2ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem2);
        this.menuBar.add(this.jMenu1);
        this.helpMenu.setMnemonic('h');
        this.helpMenu.setText("Help");
        this.contentMenuItem.setMnemonic('c');
        this.contentMenuItem.setText("Contents");
        this.helpMenu.add(this.contentMenuItem);
        this.aboutMenuItem.setMnemonic('a');
        this.aboutMenuItem.setText("About");
        this.helpMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.desktopPane, -1, 1149, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.desktopPane, -1, 668, Short.MAX_VALUE));
        this.pack();
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
    public Explorer(File ... openFiles) throws IOException {
        this.folder = openFiles.length == 0 ? new File(Runtime.USER_DIR) : openFiles[0].getParentFile();
        this.initComponents();
        for (File file : openFiles) {
            this.openFile(file);
        }
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void openMenuItemActionPerformed(ActionEvent evt) {
        int returnVal;
        JFileChooser chooser = new JFileChooser();
        chooser.setName("openFileDialog");
        chooser.setMultiSelectionEnabled(true);
        chooser.setDialogType(0);
        chooser.setFileSelectionMode(0);
        chooser.setFileFilter(new Spf4jFileFilter());
        if (this.folder != null) {
            chooser.setCurrentDirectory(this.folder);
        }
        if ((returnVal = chooser.showOpenDialog(this)) == 0) {
            File[] files;
            for (File file : files = chooser.getSelectedFiles()) {
                try {
                    this.openFile(file);
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
        }
    }

    public JMenuBar createContextMenuBar() {
        JMenuItem menuItem = null;
        JMenuBar menuBar = new JMenuBar();
        JMenu mainMenu = new JMenu("Edit");
        mainMenu.setMnemonic(69);
        menuItem = new JMenuItem(new DefaultEditorKit.CutAction());
        menuItem.setText("Cut");
        menuItem.setMnemonic(88);
        mainMenu.add(menuItem);
        menuItem = new JMenuItem(new DefaultEditorKit.CopyAction());
        menuItem.setText("Copy");
        menuItem.setMnemonic(67);
        mainMenu.add(menuItem);
        menuItem = new JMenuItem(new DefaultEditorKit.PasteAction());
        menuItem.setText("Paste");
        menuItem.setMnemonic(86);
        mainMenu.add(menuItem);
        menuBar.add(mainMenu);
        return menuBar;
    }

    private void fromTextMenuItemActionPerformed(ActionEvent evt) {
        JDialog frame = new JDialog(this, "Enter json stack samples", true);
        frame.setName("fromTextDialog");
        frame.setJMenuBar(this.createContextMenuBar());
        TextEntryPanel panel = new TextEntryPanel(samples -> {
            StackDumpJInternalFrame f = new StackDumpJInternalFrame((SampleNode)samples, "text entry", true);
            frame.setVisible(false);
            f.setVisible(true);
            this.desktopPane.add((Component)f, JLayeredPane.DEFAULT_LAYER);
        }, ex -> {
            JOptionPane.showMessageDialog(frame, "Invalid input " + ex);
            frame.setVisible(false);
            frame.dispose();
        });
        frame.getContentPane().add(panel);
        frame.pack();
        frame.setVisible(true);
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        try {
            this.sampler = Sampler.getSampler((int)10, (int)100000, (File)new File("."), (String)"dump");
            this.sampler.start();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(ex);
        }
    }

    private void jMenuItem2ActionPerformed(ActionEvent evt) {
        if (this.sampler != null) {
            try {
                this.sampler.stop();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(ex);
            }
            Map samples = this.sampler.getStackCollectionsAndReset();
            for (Map.Entry entry : samples.entrySet()) {
                try {
                    this.setFrames((SampleNode)entry.getValue(), "self:" + (String)entry.getKey());
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
        }
    }

    private void openFile(File file) throws IOException {
        String fileName = file.getName();
        if (fileName.endsWith("tsdb")) {
            TSDBViewJInternalFrame frame = new TSDBViewJInternalFrame(file);
            frame.setVisible(true);
            this.desktopPane.add((Component)frame, JLayeredPane.DEFAULT_LAYER);
        } else if (fileName.endsWith("tsdb2")) {
            TSDB2ViewJInternalFrame frame = new TSDB2ViewJInternalFrame(file);
            frame.setVisible(true);
            this.desktopPane.add((Component)frame, JLayeredPane.DEFAULT_LAYER);
        } else if (fileName.endsWith("ssdump")) {
            SampleNode samples = Explorer.loadLegacyFormat(file);
            this.setFrames(samples, fileName);
        } else if (fileName.endsWith("ssdump2")) {
            SampleNode samples = Converter.load((File)file);
            this.setFrames(samples, fileName);
        } else if (fileName.endsWith("ssdump3")) {
            Map loadLabeledDumps = Converter.loadLabeledDumps((File)file);
            for (Map.Entry entry : loadLabeledDumps.entrySet()) {
                this.setFrames((SampleNode)entry.getValue(), fileName + ':' + (String)entry.getKey());
            }
        } else {
            throw new IOException("Unsupported file format " + fileName);
        }
    }

    private static SampleNode loadLegacyFormat(File file) throws IOException {
        InputStream fis = Files.newInputStream(file.toPath(), new OpenOption[0]);
        return Explorer.loadLegacyFormat(fis);
    }

    @VisibleForTesting
    static SampleNode loadLegacyFormat(InputStream fis) throws IOException {
        try (BufferedInputStream bis = new BufferedInputStream(fis);){
            CodedInputStream is = CodedInputStream.newInstance((InputStream)bis);
            is.setRecursionLimit(Short.MAX_VALUE);
            SampleNode sampleNode = org.spf4j.stackmonitor.proto.Converter.fromProtoToSampleNode(ProtoSampleNodes.SampleNode.parseFrom(is));
            return sampleNode;
        }
    }

    private void setFrames(SampleNode samples, String fileName) throws IOException {
        StackDumpJInternalFrame frame = new StackDumpJInternalFrame(samples, fileName, false);
        frame.setVisible(true);
        this.desktopPane.add((Component)frame, JLayeredPane.DEFAULT_LAYER);
    }

    @Nullable
    private static Frame findActiveFrame() {
        Frame[] frames;
        for (Frame frame : frames = JFrame.getFrames()) {
            if (!frame.isVisible()) continue;
            return frame;
        }
        return null;
    }

    public static void main(final String[] args) {
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> {
            Frame frame = Explorer.findActiveFrame();
            if (frame != null) {
                try {
                    if (ERR_LOCK.tryLock(100L, TimeUnit.MILLISECONDS)) {
                        try {
                            JTextArea textArea = new JTextArea(Throwables.toString((Throwable)e));
                            JScrollPane scrollPane = new JScrollPane(textArea);
                            textArea.setLineWrap(true);
                            textArea.setWrapStyleWord(true);
                            scrollPane.setPreferredSize(new Dimension(500, 500));
                            JOptionPane.showConfirmDialog(frame, scrollPane, "Exception", 0, 0);
                        }
                        finally {
                            ERR_LOCK.unlock();
                        }
                    }
                    Throwables.writeTo((Throwable)e, (PrintStream)System.err, (Throwables.PackageDetail)Throwables.PackageDetail.SHORT);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    return;
                }
            } else {
                Throwables.writeTo((Throwable)e, (PrintStream)System.err, (Throwables.PackageDetail)Throwables.PackageDetail.SHORT);
            }
            if (Throwables.isNonRecoverable((Throwable)e)) {
                System.exit(SysExits.EX_SOFTWARE.exitCode());
            }
        });
        System.setProperty("spf4j.tsdb2.lenientRead", "true");
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(Explorer.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(Explorer.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(Explorer.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(Explorer.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater((Runnable)new AbstractRunnable(false){

            @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
            public void doRun() throws IOException {
                File[] files = new File[args.length];
                for (int i = 0; i < args.length; ++i) {
                    files[i] = new File(args[i]);
                }
                new Explorer(files).setVisible(true);
            }
        });
    }

    private static class Spf4jFileFilter
    extends FileFilter {
        private Spf4jFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            if (f.isFile()) {
                String name = f.getName();
                return name.endsWith("tsdb") || name.endsWith("tsdb2") || name.endsWith("ssdump") || name.endsWith("ssdump2") || name.endsWith("ssdump3");
            }
            return false;
        }

        @Override
        public String getDescription() {
            return "spf4j dumps";
        }
    }
}

