/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.ui;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gnu.trove.map.TMap;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.spf4j.base.EqualsPredicate;
import org.spf4j.base.Method;
import org.spf4j.base.Pair;
import org.spf4j.stackmonitor.SampleNode;
import org.spf4j.ui.StackPanelBase;

public final class FlameStackPanel
extends StackPanelBase<Pair<Method, SampleNode>> {
    private static final long serialVersionUID = 1L;

    public FlameStackPanel(Method method, SampleNode samples, LinkedList<Pair<Method, SampleNode>> history) {
        super(method, samples, history);
    }

    @Override
    public int paint(Graphics2D gr, double width, double rowHeight) {
        return this.paintNode(this.getMethod(), this.getSamples(), gr, 0, 0, (int)width, (int)rowHeight, 0);
    }

    @SuppressFBWarnings(value={"ISB_TOSTRING_APPENDING"})
    private int paintNode(Method method, SampleNode node, Graphics2D g2, int x, int py, int width, int height, int depth) {
        int y = py;
        int sampleCount = node.getSampleCount();
        String val = method.toString() + '-' + sampleCount;
        FlameStackPanel.setElementColor(depth, g2);
        g2.setClip(x, y, width, height);
        g2.fillRect(x, y, width, height);
        this.insert(x, y, width, height, Pair.of((Object)method, (Object)node));
        g2.setPaint(Color.BLACK);
        g2.drawString(val, x, y + height - 1);
        g2.setClip(null);
        g2.setPaint(LINK_COLOR);
        g2.drawRect(x, y, width, height);
        TMap children = node.getSubNodes();
        int result = height;
        if (children != null) {
            y += height;
            int relX = x;
            double scale = (double)width / (double)sampleCount;
            int maxY = 0;
            for (Map.Entry entry : children.entrySet()) {
                SampleNode cnode = (SampleNode)entry.getValue();
                int childWidth = (int)(scale * (double)cnode.getSampleCount());
                if (childWidth <= 0) continue;
                maxY = Math.max(maxY, this.paintNode((Method)entry.getKey(), cnode, g2, relX, y, childWidth, height, depth + 1));
                relX += childWidth;
            }
            result += maxY;
        }
        return result;
    }

    @Override
    @Nullable
    @SuppressFBWarnings(value={"ISB_TOSTRING_APPENDING"})
    public String getDetail(Point location) {
        List tips = this.search(location.x, location.y, 0, 0);
        if (tips.size() >= 1) {
            Pair m = (Pair)tips.get(0);
            return ((Method)m.getFirst()).toString() + '-' + ((SampleNode)m.getSecond()).getSampleCount();
        }
        return null;
    }

    @Override
    public void filter() {
        List tips = this.search(this.xx, this.yy, 0, 0);
        if (tips.size() >= 1) {
            Method value = (Method)((Pair)tips.get(0)).getFirst();
            this.updateSamples(this.getMethod(), this.getSamples().filteredBy((Predicate)new EqualsPredicate((Object)value)));
            this.repaint();
        }
    }

    @Override
    public void drill() {
        List tips = this.search(this.xx, this.yy, 0, 0);
        if (tips.size() >= 1) {
            Pair sample = (Pair)tips.get(0);
            this.updateSamples((Method)sample.getFirst(), (SampleNode)sample.getSecond());
            this.repaint();
        }
    }
}

