/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.ui;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.spf4j.base.EqualsPredicate;
import org.spf4j.base.Method;
import org.spf4j.base.Pair;
import org.spf4j.stackmonitor.SampleGraph;
import org.spf4j.stackmonitor.SampleNode;
import org.spf4j.ui.Arrow2D;
import org.spf4j.ui.FlameStackPanel;
import org.spf4j.ui.StackPanelBase;

@SuppressFBWarnings(value={"SE_BAD_FIELD"})
public final class HotFlameStackPanel
extends StackPanelBase<SampleGraph.SampleKey> {
    private static final long serialVersionUID = 1L;
    private SampleGraph completeGraph;
    private Map<SampleGraph.SampleKey, Rectangle2D> methodLocations;
    private double totalHeight = 0.0;

    public HotFlameStackPanel(Method method, SampleNode samples, LinkedList<Pair<Method, SampleNode>> history) {
        super(method, samples, history);
    }

    @Override
    public int paint(Graphics2D gr, double width, double rowHeight) {
        this.totalHeight = 0.0;
        this.paintGraph(gr, width, rowHeight);
        return (int)this.totalHeight;
    }

    private void paintGraph(Graphics2D g2, double areaWidth, double rowHeight) {
        SampleGraph.AggSample next;
        SampleGraph graph;
        this.completeGraph = graph = new SampleGraph(this.getMethod(), this.getSamples());
        SampleGraph.AggSample aggRoot = graph.getAggRootVertex();
        int rootSamples = aggRoot.getNrSamples();
        double pps = (areaWidth - 1.0) / (double)rootSamples;
        this.methodLocations = new HashMap<SampleGraph.SampleKey, Rectangle2D>();
        PriorityQueue<SampleGraph.AggSample> traversal = new PriorityQueue<SampleGraph.AggSample>(new SComparator(graph));
        traversal.add(aggRoot);
        HashSet<SampleGraph.AggSample> drawed = new HashSet<SampleGraph.AggSample>(graph.getAggNodesNr());
        while ((next = traversal.poll()) != null) {
            if (!drawed.add(next)) continue;
            this.drawMethod(g2, next, graph, pps, rowHeight);
            traversal.addAll(graph.getChildren(next));
        }
    }

    private void drawMethod(Graphics2D g2, SampleGraph.AggSample sample, SampleGraph graph, double pps, double rowHeight) {
        ArrayList<Point2D> fromLinks;
        Rectangle2D.Double location;
        Set<SampleGraph.AggSample> parents = graph.getParents(sample);
        if (parents.isEmpty()) {
            location = new Rectangle2D.Double(0.0, 0.0, pps * (double)sample.getNrSamples(), rowHeight);
            fromLinks = Collections.EMPTY_LIST;
        } else if (parents.size() == 1) {
            location = this.getLocationSingleParent(parents, graph, rowHeight, pps, sample);
            fromLinks = Collections.EMPTY_LIST;
        } else {
            fromLinks = new ArrayList(parents.size());
            Iterator<SampleGraph.AggSample> iterator = parents.iterator();
            SampleGraph.AggSample next = iterator.next();
            double x1 = 0.0;
            double x2 = 0.0;
            double y = 0.0;
            Rectangle2D pr = this.methodLocations.get(next.getKey());
            if (pr != null) {
                x1 = pr.getX();
                x2 = pr.getMaxX();
                y = pr.getMaxY();
                fromLinks.add(new Point2D.Float((float)pr.getCenterX(), (float)y));
            }
            while (iterator.hasNext()) {
                next = iterator.next();
                pr = this.methodLocations.get(next.getKey());
                if (pr == null) continue;
                fromLinks.add(new Point2D.Float((float)pr.getCenterX(), (float)pr.getMaxY()));
                x1 = Math.min(x1, pr.getX());
                x2 = Math.max(x2, pr.getMaxX());
                y = Math.max(y, pr.getMaxY());
            }
            if (y <= 0.0) {
                throw new IllegalStateException("No parents for " + sample);
            }
            double width = pps * (double)sample.getNrSamples();
            Double result = this.findEmptySpace(x1, y += rowHeight, width, x2);
            while (result == null) {
                result = this.findEmptySpace(x1, y += rowHeight, width, x2);
            }
            location = new Rectangle2D.Double(result.floatValue(), y, width, rowHeight);
        }
        Set<SampleGraph.AggSample> children = graph.getChildren(sample);
        ArrayList<Point2D> toLinks = new ArrayList<Point2D>(0);
        for (SampleGraph.AggSample chs : children) {
            Rectangle2D ch = this.methodLocations.get(chs.getKey());
            if (ch == null) continue;
            toLinks.add(new Point2D.Float((float)ch.getCenterX(), (float)ch.getMaxY()));
        }
        this.methodLocations.put(sample.getKey(), location);
        this.insert(location, sample.getKey());
        this.drawMethodRectangle(g2, location, sample, fromLinks, toLinks);
    }

    public Rectangle2D.Double getLocationSingleParent(Set<SampleGraph.AggSample> parents, SampleGraph graph, double rowHeight, double pps, SampleGraph.AggSample sample) {
        SampleGraph.AggSample parent = parents.iterator().next();
        Rectangle2D pRect = this.methodLocations.get(parent.getKey());
        double px = pRect.getX();
        Set<SampleGraph.AggSample> sibblings = graph.getChildren(parent);
        for (SampleGraph.AggSample sibbling : sibblings) {
            double x;
            Rectangle2D l;
            if (graph.getParents(sibbling).size() != 1 || (l = this.methodLocations.get(sibbling.getKey())) == null || !((x = l.getX() + l.getWidth()) > px)) continue;
            px = x;
        }
        return new Rectangle2D.Double(px, pRect.getY() + rowHeight, pps * (double)sample.getNrSamples(), rowHeight);
    }

    private void drawMethodRectangle(Graphics2D g2, Rectangle2D.Double location, SampleGraph.AggSample sample, List<Point2D> fromLinks, List<Point2D> toLinks) {
        double x = location.getX();
        double y = location.getY();
        double width = location.getWidth();
        double height = location.getHeight();
        double newHeight = y + height;
        if (this.totalHeight < newHeight) {
            this.totalHeight = newHeight;
        }
        FlameStackPanel.setElementColor(sample.getLevel(), g2);
        g2.setClip((int)x, (int)y, (int)width, (int)height);
        g2.fillRect((int)x, (int)y, (int)width, (int)height);
        String val = sample.getKey().getMethod().toString() + '-' + sample.getNrSamples();
        g2.setPaint(Color.BLACK);
        g2.drawString(val, (int)x, (int)(y + height - 1.0));
        g2.setClip(null);
        g2.setPaint(LINK_COLOR);
        int tx = (int)(x + width / 2.0);
        for (Point2D divLoc : fromLinks) {
            Arrow2D.draw(g2, (int)divLoc.getX(), (int)divLoc.getY(), tx, (int)y);
        }
        for (Point2D divLoc : toLinks) {
            Arrow2D.draw(g2, tx, (int)y, (int)divLoc.getX(), (int)divLoc.getY());
        }
        g2.drawRect((int)x, (int)y, (int)width, (int)height);
    }

    @Nullable
    private Double findEmptySpace(double newXBase, double newYBase, double newWidth, double maxX) {
        double tryx = Math.max(0.0, newXBase + (maxX - newXBase) / 2.0 - newWidth / 2.0);
        List methods = this.search(tryx, newYBase, newWidth, 3.4028234663852886E38 - newYBase);
        if (!methods.isEmpty() && !(methods = this.search(tryx = Math.max(0.0, newXBase), newYBase, newWidth, 3.4028234663852886E38 - newYBase)).isEmpty()) {
            tryx = Math.max(0.0, maxX - newWidth);
            methods = this.search(tryx, newYBase, newWidth, 3.4028234663852886E38 - newYBase);
        }
        if (methods.isEmpty()) {
            return tryx;
        }
        return null;
    }

    @Override
    @Nullable
    public String getDetail(Point location) {
        List tips = this.search(location.x, location.y, 0, 0);
        if (tips.size() >= 1) {
            SampleGraph.SampleKey key = (SampleGraph.SampleKey)tips.get(0);
            SampleGraph.AggSample node = this.completeGraph.getAggNode(key);
            StringBuilder sb = new StringBuilder();
            sb.append(node).append('-').append(node.getNrSamples()).append("\n invoked from: ");
            HotFlameStackPanel.appendEdgeInfo(this.completeGraph.getParents(node), sb);
            sb.append("\n invoking: ");
            HotFlameStackPanel.appendEdgeInfo(this.completeGraph.getChildren(node), sb);
            return sb.toString();
        }
        return null;
    }

    @Override
    public void filter() {
        List tips = this.search(this.xx, this.yy, 0, 0);
        if (tips.size() >= 1) {
            SampleGraph.SampleKey value = (SampleGraph.SampleKey)tips.get(0);
            this.updateSamples(this.getMethod(), this.getSamples().filteredBy((Predicate)new EqualsPredicate((Object)value.getMethod())));
            this.repaint();
        }
    }

    @Override
    public void drill() {
        List tips = this.search(this.xx, this.yy, 0, 0);
        if (tips.size() >= 1) {
            SampleGraph.SampleKey sample = (SampleGraph.SampleKey)tips.get(0);
            Set<SampleGraph.Sample> samples = this.completeGraph.getSamples(sample);
            Iterator<SampleGraph.Sample> iterator = samples.iterator();
            SampleNode agg = iterator.next().getNode();
            while (iterator.hasNext()) {
                agg = SampleNode.aggregate((SampleNode)agg, (SampleNode)iterator.next().getNode());
            }
            this.updateSamples(sample.getMethod(), agg);
            this.repaint();
        }
    }

    private static void appendEdgeInfo(Set<SampleGraph.AggSample> incomming, StringBuilder sb) {
        for (SampleGraph.AggSample entry : incomming) {
            sb.append(entry.getKey()).append('-').append(entry.getNrSamples()).append("; ");
        }
    }

    @SuppressFBWarnings(value={"SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"})
    private static final class SComparator
    implements Comparator<SampleGraph.AggSample> {
        private final SampleGraph graph;

        SComparator(SampleGraph graph) {
            this.graph = graph;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int compare(SampleGraph.AggSample a, SampleGraph.AggSample b) {
            int as = this.graph.getParents(a).size();
            int bs = this.graph.getParents(b).size();
            if (as == 1) {
                if (bs != 1) return -1;
                if (a.getLevel() < b.getLevel()) {
                    return -1;
                }
                if (a.getLevel() > b.getLevel()) {
                    return 1;
                }
            } else {
                if (bs == 1) {
                    return 1;
                }
                if (a.getLevel() < b.getLevel()) {
                    return -1;
                }
                if (a.getLevel() > b.getLevel()) {
                    return 1;
                }
            }
            if (!this.graph.haveCommonChild(a, b)) return a.getKey().getMethod().compareTo(b.getKey().getMethod());
            return 0;
        }
    }
}

