/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.ui;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.LinkedList;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.jdesktop.layout.GroupLayout;
import org.spf4j.base.Method;
import org.spf4j.base.Pair;
import org.spf4j.stackmonitor.SampleNode;
import org.spf4j.ui.FlameStackPanel;
import org.spf4j.ui.HotFlameStackPanel;
import org.spf4j.ui.StackPanelBase;

@SuppressFBWarnings(value={"FCBL_FIELD_COULD_BE_LOCAL", "SE_BAD_FIELD"})
public class StackDumpJInternalFrame
extends JInternalFrame {
    private SampleNode samples;
    private JToggleButton graphToggle;
    private JToolBar jToolBar1;
    private JScrollPane ssScrollPanel;

    public StackDumpJInternalFrame(SampleNode samples, String title, boolean isgraph) {
        super(title);
        this.setName(title);
        this.initComponents();
        this.samples = samples == null ? SampleNode.createSampleNode((StackTraceElement[])new StackTraceElement[]{new StackTraceElement("NO SAMPLES", "", "", -1)}) : samples;
        this.setViewType(isgraph);
        this.ssScrollPanel.setVisible(true);
        this.pack();
    }

    private void setViewType(boolean isgraph) {
        StackPanelBase view = (StackPanelBase)this.ssScrollPanel.getViewport().getView();
        if (isgraph) {
            this.graphToggle.setSelected(true);
            if (view != null) {
                this.ssScrollPanel.setViewportView(new HotFlameStackPanel(view.getMethod(), view.getSamples(), view.getHistory()));
            } else {
                this.ssScrollPanel.setViewportView(new HotFlameStackPanel(Method.ROOT, this.samples, new LinkedList<Pair<Method, SampleNode>>()));
            }
        } else {
            this.graphToggle.setSelected(false);
            if (view != null) {
                this.ssScrollPanel.setViewportView(new FlameStackPanel(view.getMethod(), view.getSamples(), view.getHistory()));
            } else {
                this.ssScrollPanel.setViewportView(new FlameStackPanel(Method.ROOT, this.samples, new LinkedList<Pair<Method, SampleNode>>()));
            }
        }
    }

    @SuppressFBWarnings
    private void initComponents() {
        this.ssScrollPanel = new JScrollPane();
        this.jToolBar1 = new JToolBar();
        this.graphToggle = new JToggleButton();
        this.setClosable(true);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.ssScrollPanel.setAutoscrolls(true);
        this.jToolBar1.setRollover(true);
        this.graphToggle.setText("graph");
        this.graphToggle.setFocusable(false);
        this.graphToggle.setHorizontalTextPosition(0);
        this.graphToggle.setVerticalTextPosition(3);
        this.graphToggle.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                StackDumpJInternalFrame.this.graphToggleItemStateChanged(evt);
            }
        });
        this.jToolBar1.add(this.graphToggle);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.ssScrollPanel, -1, 412, Short.MAX_VALUE).add((Component)this.jToolBar1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jToolBar1, -2, 25, -2).addPreferredGap(0).add((Component)this.ssScrollPanel, -1, 339, Short.MAX_VALUE)));
        this.pack();
    }

    private void graphToggleItemStateChanged(ItemEvent evt) {
        this.setViewType(evt.getStateChange() == 1);
    }
}

