/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.ui;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.ToolTipManager;
import org.spf4j.base.Method;
import org.spf4j.base.Pair;
import org.spf4j.ds.RTree;
import org.spf4j.stackmonitor.SampleNode;

public abstract class StackPanelBase<T>
extends JPanel
implements ActionListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    private SampleNode samples;
    private Method method;
    private RTree<T> samplesRTree = new RTree();
    protected int xx;
    protected int yy;
    private final JPopupMenu menu;
    private final LinkedList<Pair<Method, SampleNode>> history;
    private volatile BufferedImage img;
    private volatile int imgWidth;
    public static final Color LINK_COLOR = new Color(128, 128, 128, 128);

    public StackPanelBase(Method method, SampleNode samples, LinkedList<Pair<Method, SampleNode>> history) {
        this.samples = samples;
        this.method = method;
        this.history = history;
        this.setPreferredSize(new Dimension(400, 20 * samples.height() + 10));
        ToolTipManager sharedInstance = ToolTipManager.sharedInstance();
        sharedInstance.registerComponent(this);
        sharedInstance.setDismissDelay(30000);
        this.menu = StackPanelBase.buildPopupMenu(this);
        this.addMouseListener(this);
    }

    public final List<T> search(int x, int y, int w, int h) {
        return this.samplesRTree.search(new float[]{x, y}, new float[]{w, h});
    }

    public final List<T> search(double x, double y, double w, double h) {
        return this.samplesRTree.search(new float[]{(float)x, (float)y}, new float[]{(float)w, (float)h});
    }

    public final void insert(int x, int y, int w, int h, T sampled) {
        this.samplesRTree.insert(new float[]{x, y}, new float[]{w, h}, sampled);
    }

    public final void insert(double x, double y, double w, double h, T sampled) {
        this.samplesRTree.insert(new float[]{(float)x, (float)y}, new float[]{(float)w, (float)h}, sampled);
    }

    public final void insert(Rectangle2D.Double rect, T sampled) {
        this.samplesRTree.insert(new float[]{(float)rect.getX(), (float)rect.getY()}, new float[]{(float)rect.getWidth(), (float)rect.getHeight()}, sampled);
    }

    @SuppressFBWarnings(value={"S508C_NON_TRANSLATABLE_STRING"})
    private static JPopupMenu buildPopupMenu(ActionListener listener) {
        JPopupMenu result = new JPopupMenu("Actions");
        JMenuItem filter = new JMenuItem("Filter");
        filter.setActionCommand("FILTER");
        filter.addActionListener(listener);
        result.add(filter);
        JMenuItem drill = new JMenuItem("Drill");
        drill.setActionCommand("DRILL");
        drill.addActionListener(listener);
        result.add(drill);
        JMenuItem back = new JMenuItem("Back");
        back.setActionCommand("BACK");
        back.addActionListener(listener);
        result.add(back);
        JMenuItem copy = new JMenuItem("Copy");
        copy.setActionCommand("COPY");
        copy.addActionListener(listener);
        result.add(copy);
        return result;
    }

    @Override
    public final String getToolTipText(MouseEvent event) {
        Point location = event.getPoint();
        return this.getDetail(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"})
    public final void paintComponent(Graphics g) {
        super.paintComponent(g);
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            int width1 = (int)size.getWidth();
            if (this.img == null || this.imgWidth != width1) {
                double rowHeight = g2.getFont().getStringBounds("ROOT", g2.getFontRenderContext()).getHeight() + 2.0;
                this.img = this.paintImage(g2, width1 - insets.left - insets.right, rowHeight);
                Dimension dimension = new Dimension(this.img.getWidth(), this.img.getHeight());
                this.setPreferredSize(dimension);
                this.imgWidth = width1;
            }
            g2.drawImage((Image)this.img, insets.left, insets.top, this);
        }
        finally {
            g2.dispose();
        }
    }

    private BufferedImage paintImage(Graphics2D g2, int width, double rowHeight) {
        GraphicsConfiguration gc = g2.getDeviceConfiguration();
        int height = 5000;
        while (true) {
            BufferedImage limg = gc.createCompatibleImage(width, height, 3);
            Graphics2D gr = limg.createGraphics();
            gr.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            int nheight = this.repaint(gr, width, rowHeight) + 10;
            gr.dispose();
            if (nheight < height) {
                return limg.getSubimage(0, 0, width, nheight);
            }
            height = nheight;
        }
    }

    private int repaint(Graphics2D gr, double width, double rowHeight) {
        this.samplesRTree.clear();
        return this.paint(gr, width, rowHeight);
    }

    public abstract int paint(Graphics2D var1, double var2, double var4);

    @Override
    public final void actionPerformed(ActionEvent e) {
        String actionCommand;
        switch (actionCommand = e.getActionCommand()) {
            case "FILTER": {
                this.history.addLast((Pair<Method, SampleNode>)Pair.of((Object)this.method, (Object)this.samples));
                this.filter();
                break;
            }
            case "DRILL": {
                this.history.addLast((Pair<Method, SampleNode>)Pair.of((Object)this.method, (Object)this.samples));
                this.drill();
                break;
            }
            case "BACK": {
                Pair<Method, SampleNode> prev = this.history.pollLast();
                if (prev == null) break;
                this.updateSamples((Method)prev.getFirst(), (SampleNode)prev.getSecond());
                this.repaint();
                break;
            }
            case "COPY": {
                final String detail = this.getDetail(new Point(this.xx, this.yy));
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new Transferable(){

                    @Override
                    public DataFlavor[] getTransferDataFlavors() {
                        return new DataFlavor[]{DataFlavor.stringFlavor};
                    }

                    @Override
                    public boolean isDataFlavorSupported(DataFlavor flavor) {
                        return flavor.equals(DataFlavor.stringFlavor);
                    }

                    @Override
                    public Object getTransferData(DataFlavor flavor) {
                        return detail;
                    }
                }, new ClipboardOwner(){

                    @Override
                    public void lostOwnership(Clipboard clipboard, Transferable contents) {
                    }
                });
                break;
            }
        }
    }

    @Override
    public final void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.xx = e.getX();
            this.yy = e.getY();
            this.menu.show(this, e.getX(), e.getY());
        }
    }

    @Override
    public final void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.xx = e.getX();
            this.yy = e.getY();
            this.menu.show(this, e.getX(), e.getY());
        }
    }

    @Override
    @SuppressFBWarnings
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    @SuppressFBWarnings
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    @SuppressFBWarnings
    public void mouseExited(MouseEvent e) {
    }

    public static void setElementColor(int depth, Graphics2D g2) {
        if (depth % 2 == 0) {
            g2.setPaint(Color.YELLOW);
            g2.setBackground(Color.YELLOW);
        } else {
            g2.setPaint(Color.ORANGE);
            g2.setBackground(Color.ORANGE);
        }
    }

    public void updateSamples(Method m, SampleNode n) {
        this.samples = n;
        this.method = m;
        this.img = null;
    }

    public final SampleNode getSamples() {
        return this.samples;
    }

    public final Method getMethod() {
        return this.method;
    }

    public final LinkedList<Pair<Method, SampleNode>> getHistory() {
        return this.history;
    }

    @Nullable
    public abstract String getDetail(Point var1);

    public abstract void filter();

    public abstract void drill();
}

