/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.ui;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.TransferHandler;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.spf4j.stackmonitor.SampleNode;

@SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED", "SE_BAD_FIELD"})
public class TextEntryPanel
extends JPanel {
    private transient Consumer<SampleNode> nodeConsumer;
    private transient Consumer<Exception> errorConsumer;
    private JScrollPane jScrollPane1;
    private JTextPane jTextPane1;

    public TextEntryPanel(Consumer<SampleNode> nodeConsumer, Consumer<Exception> errorConsumer) {
        this.initComponents();
        this.nodeConsumer = nodeConsumer;
        this.errorConsumer = errorConsumer;
        TextTransferHandler th = new TextTransferHandler();
        this.jTextPane1.setTransferHandler(th);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTextPane1 = new JTextPane();
        JButton display = new JButton();
        this.jTextPane1.setName("textBox");
        this.jTextPane1.setOpaque(false);
        this.jTextPane1.setRequestFocusEnabled(false);
        this.jScrollPane1.setViewportView(this.jTextPane1);
        display.setText("Display");
        display.setName("display");
        display.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextEntryPanel.this.displayActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollPane1).addContainerGap()).addGroup(layout.createSequentialGroup().addGap(152, 152, 152).addComponent(display).addContainerGap(186, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 256, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(display).addContainerGap()));
    }

    @SuppressFBWarnings(value={"UP_UNUSED_PARAMETER"})
    private void displayActionPerformed(ActionEvent evt) {
        try {
            this.nodeConsumer.accept((SampleNode)SampleNode.parse((Reader)new StringReader(this.jTextPane1.getText())).getSecond());
        }
        catch (IOException | RuntimeException ex) {
            this.errorConsumer.accept(ex);
        }
    }

    private static final class TextTransferHandler
    extends TransferHandler {
        Position p0 = null;
        Position p1 = null;

        private TextTransferHandler() {
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            String data;
            if (!this.canImport(support)) {
                return false;
            }
            try {
                data = (String)support.getTransferable().getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException | IOException e) {
                Logger.getLogger(TextEntryPanel.class.getName()).log(Level.WARNING, "Exception encountered", e);
                return false;
            }
            JTextPane tc = (JTextPane)support.getComponent();
            tc.replaceSelection(data);
            return true;
        }

        @Override
        @Nullable
        protected Transferable createTransferable(JComponent c) {
            JTextPane source = (JTextPane)c;
            int start = source.getSelectionStart();
            int end = source.getSelectionEnd();
            Document doc = source.getDocument();
            if (start == end) {
                return null;
            }
            try {
                this.p0 = doc.createPosition(start);
                this.p1 = doc.createPosition(end);
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
            String data = source.getSelectedText();
            return new StringSelection(data);
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 3;
        }

        @Override
        protected void exportDone(JComponent c, Transferable data, int action) {
            if (action != 2) {
                return;
            }
            if (this.p0 != null && this.p1 != null && this.p0.getOffset() != this.p1.getOffset()) {
                try {
                    JTextComponent tc = (JTextComponent)c;
                    tc.getDocument().remove(this.p0.getOffset(), this.p1.getOffset() - this.p0.getOffset());
                }
                catch (BadLocationException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return support.isDataFlavorSupported(DataFlavor.stringFlavor);
        }
    }
}

