/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.zel.vm;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public final class SimpleStack<T>
implements List<T> {
    private static final int DEFAULT_SIZE = 32;
    private T[] elems;
    private int top;

    public SimpleStack(int size) {
        this.elems = new Object[size];
        this.top = 0;
    }

    public SimpleStack() {
        this(32);
    }

    @Override
    public boolean isEmpty() {
        return this.top == 0;
    }

    public void push(T o) {
        int t = this.top + 1;
        this.ensureCapacity(t);
        this.elems[this.top] = o;
        this.top = t;
    }

    private void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elems.length;
        if (minCapacity > oldCapacity) {
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elems = Arrays.copyOf(this.elems, newCapacity);
        }
    }

    public void pushAll(T[] args) {
        if (args.length == 0) {
            return;
        }
        int newTop = this.top + args.length;
        this.ensureCapacity(newTop);
        System.arraycopy(args, 0, this.elems, this.top, args.length);
        this.top = newTop;
    }

    public T pop() {
        T o = this.elems[--this.top];
        this.elems[this.top] = null;
        return o;
    }

    public void remove() {
        --this.top;
        this.elems[this.top] = null;
    }

    public T[] pop(int n) {
        int ot = this.top;
        this.top -= n;
        Object[] result = new Object[n];
        int i = this.top;
        int j = 0;
        while (i < ot) {
            result[j] = this.elems[i];
            this.elems[i] = null;
            ++i;
            ++j;
        }
        return result;
    }

    public void popTo(T[] to, int n) {
        int ot = this.top;
        this.top -= n;
        int i = this.top;
        int j = 0;
        while (i < ot) {
            to[j] = this.elems[i];
            this.elems[i] = null;
            ++i;
            ++j;
        }
    }

    public void removeFromTop(int n) {
        int ot = this.top;
        this.top -= n;
        for (int i = this.top; i < ot; ++i) {
            this.elems[i] = null;
        }
    }

    public T[] popUntil(T until) {
        int i = this.top - 1;
        while (this.elems[i] != until) {
            --i;
        }
        T[] result = Arrays.copyOfRange(this.elems, i + 1, this.top);
        Arrays.fill(this.elems, i, this.top, null);
        this.top = i;
        return result;
    }

    public T peek() {
        return this.elems[this.top - 1];
    }

    public T peekFromTop(int n) {
        return this.elems[this.top - 1 - n];
    }

    public void replaceFromTop(int n, T value) {
        this.elems[this.top - 1 - n] = value;
    }

    public T[] peek(int n) {
        return Arrays.copyOfRange(this.elems, this.top - n, this.top);
    }

    public T[] peekUntil(T until) {
        int i = this.top - 1;
        while (this.elems[i] != until) {
            --i;
        }
        return Arrays.copyOfRange(this.elems, i + 1, this.top);
    }

    public T peekElemAfter(T until) {
        int i = this.top - 1;
        while (this.elems[i] != until) {
            --i;
        }
        return this.elems[i - 1];
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.top; ++i) {
            this.elems[i] = null;
        }
        this.top = 0;
    }

    public int getPtr() {
        return this.top;
    }

    public T getFromPtr(int ptr) {
        if (ptr < 0 || ptr >= this.top) {
            throw new IndexOutOfBoundsException("Trying to get from invalid index: " + ptr + " from: " + this);
        }
        return this.elems[ptr];
    }

    public String toString(char separator) {
        if (this.top == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder(32);
        result.append(this.elems[0]);
        for (int i = 1; i < this.top; ++i) {
            result.append(separator);
            result.append(this.elems[i]);
        }
        return result.toString();
    }

    public String toString() {
        return this.toString('.');
    }

    @Override
    public int size() {
        return this.top;
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Iterator<T> iterator() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean add(T e) {
        this.push(e);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleStack other = (SimpleStack)obj;
        if (this.top != other.top) {
            return false;
        }
        return org.spf4j.base.Arrays.deepEquals((Object[])this.elems, (Object[])other.elems, (int)0, (int)this.top);
    }

    @Override
    public int hashCode() {
        int hashCode = 7;
        for (int i = 0; i < this.top; ++i) {
            T obj = this.elems[i];
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
        }
        return hashCode;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public T get(int index) {
        return this.elems[index];
    }

    @Override
    public T set(int index, T element) {
        this.ensureCapacity(index);
        T result = this.elems[index];
        this.elems[index] = element;
        return result;
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int indexOf(Object o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ListIterator<T> listIterator() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

