/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import spire.math.ULong;
import spire.math.ULongAlgebra;
import spire.math.ULongBitString;
import spire.math.ULongInstances;
import spire.math.ULongInstances$class;

public final class ULong$
implements ULongInstances {
    public static final ULong$ MODULE$;
    private final long MinValue;
    private final long MaxValue;
    private final BigInt bigIntOffset;
    private final ULongAlgebra ULongAlgebra;
    private final ULongBitString ULongBitString;

    static {
        new ULong$();
    }

    @Override
    public final ULongAlgebra ULongAlgebra() {
        return this.ULongAlgebra;
    }

    @Override
    public final ULongBitString ULongBitString() {
        return this.ULongBitString;
    }

    @Override
    public final void spire$math$ULongInstances$_setter_$ULongAlgebra_$eq(ULongAlgebra x$1) {
        this.ULongAlgebra = x$1;
    }

    @Override
    public final void spire$math$ULongInstances$_setter_$ULongBitString_$eq(ULongBitString x$1) {
        this.ULongBitString = x$1;
    }

    public final long apply(long n) {
        return n;
    }

    public final long apply(String s) {
        return this.fromBigInt(package$.MODULE$.BigInt().apply(s));
    }

    public final long fromInt(int n) {
        return (long)n & 0xFFFFFFFFL;
    }

    public final long fromLong(long n) {
        return n;
    }

    public final long fromBigInt(BigInt n) {
        if (n.$less(BigInt$.MODULE$.int2bigInt(0))) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " < 0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{n})));
        }
        return n.toLong();
    }

    public BigInt ulongToBigInt(long n) {
        return this.toBigInt$extension(n);
    }

    public final long MinValue() {
        return this.MinValue;
    }

    public final long MaxValue() {
        return this.MaxValue;
    }

    public final long pow(long t, long b, long e) {
        while (e != 0L) {
            if ((e & 1L) == 1L) {
                long l = t * b;
                e >>>= (int)1L;
                b *= b;
                t = l;
                continue;
            }
            e >>>= (int)1L;
            b *= b;
        }
        return t;
    }

    public final long gcd(long a, long b) {
        while (!this.$eq$eq$extension(b, 0L)) {
            long l = b;
            b = this.$percent$extension(a, b);
            a = l;
        }
        return a;
    }

    public final BigInt bigIntOffset() {
        return this.bigIntOffset;
    }

    public final byte toByte$extension(long $this) {
        return (byte)$this;
    }

    public final char toChar$extension(long $this) {
        return (char)$this;
    }

    public final short toShort$extension(long $this) {
        return (short)$this;
    }

    public final int toInt$extension(long $this) {
        return (int)$this;
    }

    public final long toLong$extension(long $this) {
        return $this;
    }

    public final float toFloat$extension(long $this) {
        return $this < 0L ? -((float)Long.MIN_VALUE) - (float)$this : (float)$this;
    }

    public final double toDouble$extension(long $this) {
        return $this < 0L ? -((double)Long.MIN_VALUE) - (double)$this : (double)$this;
    }

    public final BigInt toBigInt$extension(long $this) {
        return $this >= 0L ? package$.MODULE$.BigInt().apply($this) : this.bigIntOffset().$plus(BigInt$.MODULE$.long2bigInt($this & Long.MAX_VALUE));
    }

    public final String toString$extension(long $this) {
        return $this >= 0L ? ((Object)BoxesRunTime.boxToLong((long)$this)).toString() : package$.MODULE$.BigInt().apply(Long.MIN_VALUE).unary_$minus().$times(BigInt$.MODULE$.int2bigInt(2)).$plus(package$.MODULE$.BigInt().apply($this)).toString();
    }

    public final boolean $eq$eq$extension(long $this, long that) {
        return $this == that;
    }

    public final boolean $bang$eq$extension(long $this, long that) {
        return $this != that;
    }

    public final boolean $less$eq$extension(long $this, long that) {
        return $this >= 0L ? $this <= that || that < 0L : that >= $this && that < 0L;
    }

    public final boolean $less$extension(long $this, long that) {
        return $this >= 0L ? $this < that || that < 0L : that > $this && that < 0L;
    }

    public final boolean $greater$eq$extension(long $this, long that) {
        return this.$less$eq$extension(that, $this);
    }

    public final boolean $greater$extension(long $this, long that) {
        return this.$less$extension(that, $this);
    }

    public final long unary_$minus$extension(long $this) {
        ULong$ uLong$ = this;
        return $this;
    }

    public final long $plus$extension(long $this, long that) {
        long l = $this + that;
        ULong$ uLong$ = this;
        return l;
    }

    public final long $minus$extension(long $this, long that) {
        long l = $this - that;
        ULong$ uLong$ = this;
        return l;
    }

    public final long $times$extension(long $this, long that) {
        long l = $this * that;
        ULong$ uLong$ = this;
        return l;
    }

    public final long $div$extension(long $this, long that) {
        long l;
        if (that == 0L) {
            throw new ArithmeticException("/ by zero");
        }
        if (that < 0L) {
            long l2 = $this >= 0L || $this < that ? 0 : 1;
            ULong$ uLong$ = this;
            l = l2;
        } else if ($this >= 0L) {
            long l3 = $this / that;
            ULong$ uLong$ = this;
            l = l3;
        } else {
            long half = $this >>> 1;
            if (half < that) {
                ULong$ uLong$ = this;
                l = 1L;
            } else {
                long l4 = (half / that << 1) + ((half % that << 1) + ($this & 1L)) / that;
                ULong$ uLong$ = this;
                l = l4;
            }
        }
        return l;
    }

    public final long $percent$extension(long $this, long that) {
        return this.$minus$extension($this, this.$times$extension(this.$div$extension($this, that), that));
    }

    public final Tuple2<ULong, ULong> $div$percent$extension(long $this, long that) {
        long q = this.$div$extension($this, that);
        return new Tuple2((Object)new ULong(q), (Object)new ULong(this.$minus$extension($this, this.$times$extension(q, that))));
    }

    public final long unary_$tilde$extension(long $this) {
        long l = $this ^ 0xFFFFFFFFFFFFFFFFL;
        ULong$ uLong$ = this;
        return l;
    }

    public final long $less$less$extension(long $this, int shift) {
        long l = $this << shift;
        ULong$ uLong$ = this;
        return l;
    }

    public final long $greater$greater$extension(long $this, int shift) {
        long l = $this >>> shift;
        ULong$ uLong$ = this;
        return l;
    }

    public final long $greater$greater$greater$extension(long $this, int shift) {
        long l = $this >>> shift;
        ULong$ uLong$ = this;
        return l;
    }

    public final long $amp$extension(long $this, long that) {
        long l = $this & that;
        ULong$ uLong$ = this;
        return l;
    }

    public final long $bar$extension(long $this, long that) {
        long l = $this | that;
        ULong$ uLong$ = this;
        return l;
    }

    public final long $up$extension(long $this, long that) {
        long l = $this ^ that;
        ULong$ uLong$ = this;
        return l;
    }

    public final long $times$times$extension(long $this, long that) {
        return this.pow(1L, $this, that);
    }

    public final long gcd$extension(long $this, long that) {
        return this.gcd($this, that);
    }

    public final int hashCode$extension(long $this) {
        return ((Object)BoxesRunTime.boxToLong((long)$this)).hashCode();
    }

    public final boolean equals$extension(long $this, Object x$1) {
        long l;
        boolean bl = x$1 instanceof ULong;
        return bl && $this == (l = ((ULong)x$1).signed());
    }

    private ULong$() {
        MODULE$ = this;
        ULongInstances$class.$init$(this);
        ULong$ uLong$ = this;
        this.MinValue = 0L;
        ULong$ uLong$2 = this;
        this.MaxValue = -1L;
        this.bigIntOffset = package$.MODULE$.BigInt().apply(Long.MAX_VALUE).$plus(BigInt$.MODULE$.int2bigInt(1));
    }
}

