/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.spring.mock;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.spockframework.mock.IDefaultResponse;
import org.spockframework.mock.IMockInteraction;
import org.spockframework.mock.IMockObject;
import org.spockframework.mock.IResponseGenerator;
import org.spockframework.mock.ISpockMockObject;
import org.spockframework.mock.runtime.IProxyBasedMockInterceptor;
import org.spockframework.runtime.model.FieldInfo;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.util.Assert;
import org.spockframework.util.ExceptionUtil;
import spock.lang.Specification;

public class DelegatingInterceptor
implements IProxyBasedMockInterceptor {
    private final FieldInfo fieldInfo;
    private Object delegate;

    public DelegatingInterceptor(FieldInfo fieldInfo) {
        this.fieldInfo = fieldInfo;
    }

    public Object intercept(Object target, Method method, Object[] arguments, IResponseGenerator realMethodInvoker) {
        if (method.getDeclaringClass() == ISpockMockObject.class) {
            return new MockObjectAdapter(this);
        }
        if (this.delegate == null) {
            if ("toString".equals(method.getName())) {
                return String.format("Mock for '%s.%s:%d'", ((SpecInfo)this.fieldInfo.getParent()).getName(), this.fieldInfo.getName(), this.fieldInfo.getLine());
            }
            if ("equals".equals(method.getName())) {
                return this.fieldInfo.equals(arguments[0]);
            }
            if ("hashCode".equals(method.getName())) {
                return this.fieldInfo.hashCode();
            }
            return null;
        }
        try {
            return method.invoke(this.delegate, arguments);
        }
        catch (IllegalAccessException e) {
            ExceptionUtil.sneakyThrow((Throwable)e);
        }
        catch (InvocationTargetException e) {
            ExceptionUtil.sneakyThrow((Throwable)e.getTargetException());
        }
        return null;
    }

    public void attach(Specification specification) {
        this.delegate = this.fieldInfo.readValue((Object)specification);
        Assert.notNull((Object)this.delegate, (String)"delegate may not be null after attaching to a specification.", (Object[])new Object[0]);
    }

    public void detach() {
        this.delegate = null;
    }

    private static class MockObjectAdapter
    implements IMockObject {
        private final DelegatingInterceptor delegatingInterceptor;

        public MockObjectAdapter(DelegatingInterceptor delegatingInterceptor) {
            this.delegatingInterceptor = delegatingInterceptor;
        }

        public void attach(Specification specification) {
            this.delegatingInterceptor.attach(specification);
        }

        public void detach() {
            this.delegatingInterceptor.detach();
        }

        public String getName() {
            return null;
        }

        public Class<?> getType() {
            return null;
        }

        public Type getExactType() {
            return null;
        }

        public Object getInstance() {
            return null;
        }

        public boolean isVerified() {
            return false;
        }

        public IDefaultResponse getDefaultResponse() {
            return null;
        }

        public Specification getSpecification() {
            return null;
        }

        public boolean matches(Object target, IMockInteraction interaction) {
            return false;
        }
    }
}

